/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConditionalElementDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.GroupElementFactory;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;

public class GroupElementBuilder
implements RuleConditionBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        ConditionalElementDescr cedescr = (ConditionalElementDescr)((Object)descr);
        GroupElement ge = this.newGroupElementFor(descr);
        context.getBuildStack().push((RuleConditionElement)ge);
        if (prefixPattern != null) {
            ge.addChild((RuleConditionElement)prefixPattern);
        }
        for (BaseDescr baseDescr : cedescr.getDescrs()) {
            baseDescr.setResource(context.getRuleDescr().getResource());
            baseDescr.setNamespace(context.getRuleDescr().getNamespace());
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(baseDescr.getClass());
            if (builder != null) {
                RuleConditionElement element = builder.build(context, baseDescr);
                if (element == null) continue;
                ge.addChild(element);
                continue;
            }
            throw new RuntimeException("BUG: no builder found for descriptor class " + baseDescr.getClass());
        }
        context.getBuildStack().pop();
        return ge;
    }

    protected GroupElement newGroupElementFor(BaseDescr baseDescr) {
        Class<?> descr = baseDescr.getClass();
        if (AndDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newAndInstance();
        }
        if (OrDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newOrInstance();
        }
        if (NotDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newNotInstance();
        }
        if (ExistsDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newExistsInstance();
        }
        throw new RuntimeException("BUG: Not able to create a group element for descriptor: " + descr.getName());
    }
}

