/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternDestinationDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternHandler
extends BaseAbstractHandler
implements Handler {
    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String objectType = attrs.getValue("object-type");
        if (objectType == null || objectType.trim().equals("")) {
            throw new SAXParseException("<pattern> requires an 'object-type' attribute", parser.getLocator());
        }
        PatternDescr patternDescr = null;
        String identifier = attrs.getValue("identifier");
        patternDescr = identifier == null || identifier.trim().equals("") ? new PatternDescr(objectType) : new PatternDescr(objectType, identifier);
        return patternDescr;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        PatternDescr patternDescr = (PatternDescr)parser.getCurrent();
        Object parent = parser.getParent();
        if (parent instanceof PatternDestinationDescr) {
            PatternDestinationDescr parentDescr = (PatternDestinationDescr)parent;
            parentDescr.setInputPattern(patternDescr);
        } else {
            ConditionalElementDescr parentDescr = (ConditionalElementDescr)parent;
            parentDescr.addDescr(patternDescr);
        }
        return patternDescr;
    }

    public Class generateNodeFor() {
        return PatternDescr.class;
    }
}

