/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commons.jci.compilers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Compiler;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.LocatedException;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;
import org.drools.commons.jci.compilers.AbstractJavaCompiler;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.JaninoCompilationProblem;
import org.drools.commons.jci.compilers.JaninoJavaCompilerSettings;
import org.drools.commons.jci.compilers.JavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.commons.jci.stores.ResourceStore;

public final class JaninoJavaCompiler
extends AbstractJavaCompiler {
    private final JaninoJavaCompilerSettings defaultSettings;

    public JaninoJavaCompiler() {
        this(new JaninoJavaCompilerSettings());
    }

    public JaninoJavaCompiler(JaninoJavaCompilerSettings pSettings) {
        this.defaultSettings = pSettings;
    }

    public CompilationResult compile(String[] pSourceNames, final ResourceReader pResourceReader, final ResourceStore pStore, ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        final ArrayList<JaninoCompilationProblem> problems = new ArrayList<JaninoCompilationProblem>();
        StringPattern[] pattern = StringPattern.PATTERNS_NONE;
        Compiler compiler = new Compiler(new ResourceFinder(){

            public Resource findResource(String pSourceName) {
                byte[] bytes = pResourceReader.getBytes(pSourceName);
                if (bytes == null) {
                    return null;
                }
                return new JciResource(pSourceName, bytes);
            }
        }, (IClassLoader)new ClassLoaderIClassLoader(pClassLoader), new ResourceFinder(){

            public Resource findResource(String pResourceName) {
                byte[] bytes = pStore.read(pResourceName);
                if (bytes == null) {
                    return null;
                }
                return new JciResource(pResourceName, bytes);
            }
        }, new ResourceCreator(){

            public OutputStream createResource(String pResourceName) throws IOException {
                return new JciOutputStream(pResourceName, pStore);
            }

            public boolean deleteResource(String pResourceName) {
                pStore.remove(pResourceName);
                return true;
            }
        }, pSettings.getSourceEncoding(), false, pSettings.isDebug() ? DebuggingInformation.ALL : DebuggingInformation.NONE, (WarningHandler)new FilterWarningHandler(pattern, new WarningHandler(){

            public void handleWarning(String pHandle, String pMessage, Location pLocation) {
                JaninoCompilationProblem problem = new JaninoCompilationProblem(pLocation.getFileName(), pLocation, pMessage, false);
                if (JaninoJavaCompiler.this.problemHandler != null) {
                    JaninoJavaCompiler.this.problemHandler.handle(problem);
                }
                problems.add(problem);
            }
        }));
        compiler.setCompileErrorHandler(new UnitCompiler.ErrorHandler(){

            public void handleError(String pMessage, Location pLocation) throws CompileException {
                JaninoCompilationProblem problem = new JaninoCompilationProblem(pLocation.getFileName(), pLocation, pMessage, true);
                if (JaninoJavaCompiler.this.problemHandler != null) {
                    JaninoJavaCompiler.this.problemHandler.handle(problem);
                }
                problems.add(problem);
            }
        });
        Resource[] resources = new Resource[pSourceNames.length];
        for (int i = 0; i < pSourceNames.length; ++i) {
            byte[] source = pResourceReader.getBytes(pSourceNames[i]);
            resources[i] = new JciResource(pSourceNames[i], source);
        }
        try {
            compiler.compile(resources);
        }
        catch (Scanner.ScanException e) {
            problems.add(new JaninoCompilationProblem((LocatedException)e));
        }
        catch (Parser.ParseException e) {
            problems.add(new JaninoCompilationProblem((LocatedException)e));
        }
        catch (IOException e) {
        }
        catch (CompileException e) {
            // empty catch block
        }
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.defaultSettings;
    }

    private final class JciOutputStream
    extends ByteArrayOutputStream {
        private final String name;
        private final ResourceStore store;

        public JciOutputStream(String pName, ResourceStore pStore) {
            this.name = pName;
            this.store = pStore;
        }

        public void close() throws IOException {
            super.close();
            byte[] bytes = this.toByteArray();
            this.store.write(this.name, bytes);
        }
    }

    private static final class JciResource
    implements Resource {
        private final String name;
        private final byte[] bytes;

        public JciResource(String pName, byte[] pBytes) {
            this.name = pName;
            this.bytes = pBytes;
        }

        public String getFileName() {
            return this.name;
        }

        public long lastModified() {
            return 0L;
        }

        public InputStream open() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }
}

