/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSTrackpoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackpoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminUnsupportedMethodException;

public class GarminTrackpointD301
implements GarminTrackpoint {
    public int display_;
    public double latitude_;
    public double longitude_;
    public long time_;
    public float altitude_;
    public float depth_;
    public boolean new_track_;
    protected static final int TRACKPOINT_TYPE = 301;

    public GarminTrackpointD301() {
    }

    public GarminTrackpointD301(int[] buffer) {
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 2);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 6);
        this.time_ = GarminDataConverter.getGarminLongWord(buffer, 10);
        this.altitude_ = GarminDataConverter.getGarminFloat(buffer, 14);
        this.depth_ = GarminDataConverter.getGarminFloat(buffer, 18);
        this.new_track_ = GarminDataConverter.getGarminBoolean(buffer, 22);
    }

    public GarminTrackpointD301(GarminPacket pack) {
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        this.time_ = pack.getNextAsLongWord();
        this.altitude_ = pack.getNextAsFloat();
        this.depth_ = pack.getNextAsFloat();
        this.new_track_ = pack.getNextAsBoolean();
    }

    public GarminTrackpointD301(GPSTrackpoint trackpoint) {
        this.latitude_ = trackpoint.getLatitude();
        this.longitude_ = trackpoint.getLongitude();
        this.time_ = GarminDataConverter.convertDateToGarminTime(trackpoint.getDate());
        this.altitude_ = trackpoint.hasValidAltitude() ? (float)trackpoint.getAltitude() : 1.0E25f;
        this.depth_ = 1.0E25f;
        this.new_track_ = trackpoint.isNewTrack();
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 21;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsLongWord(this.time_);
        pack.setNextAsFloat(this.altitude_);
        pack.setNextAsFloat(this.depth_);
        pack.setNextAsBoolean(this.new_track_);
        return pack;
    }

    public int getType() throws GarminUnsupportedMethodException {
        return 301;
    }

    public double getLatitude() throws GarminUnsupportedMethodException {
        return this.latitude_;
    }

    public void setLatitude(double latitude) throws GarminUnsupportedMethodException {
        this.latitude_ = latitude;
    }

    public double getLongitude() throws GarminUnsupportedMethodException {
        return this.longitude_;
    }

    public void setLongitude(double longitude) throws GarminUnsupportedMethodException {
        this.longitude_ = longitude;
    }

    public long getTime() throws GarminUnsupportedMethodException {
        return this.time_;
    }

    public void setTime(long time) throws GarminUnsupportedMethodException {
        this.time_ = time;
    }

    public float getAltitude() throws GarminUnsupportedMethodException {
        return this.altitude_;
    }

    public void setAltitude(float altitude) throws GarminUnsupportedMethodException {
        this.altitude_ = altitude;
    }

    public float getDepth() throws GarminUnsupportedMethodException {
        return this.depth_;
    }

    public void setDepth(float depth) throws GarminUnsupportedMethodException {
        this.depth_ = depth;
    }

    public boolean isNewTrack() throws GarminUnsupportedMethodException {
        return this.new_track_;
    }

    public void setNewTrack(boolean new_track) throws GarminUnsupportedMethodException {
        this.new_track_ = new_track;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GarminTrackpoint[");
        buffer.append("lat=").append(this.latitude_).append(", ");
        buffer.append("lon=").append(this.longitude_).append(", ");
        buffer.append("time=").append(this.time_).append(", ");
        buffer.append("alt=").append(this.altitude_).append(", ");
        buffer.append("depth=").append(this.depth_).append(", ");
        buffer.append("new_track=").append(this.new_track_);
        buffer.append("]");
        return buffer.toString();
    }
}

