/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSRoute;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminRoute;

public class GarminRouteD201
extends GarminRoute {
    protected static byte route_id_ = 1;

    public GarminRouteD201(int[] buffer) {
        this.setIdentification(Integer.toString(GarminDataConverter.getGarminByte(buffer, 2)));
        this.setComment(GarminDataConverter.getGarminString(buffer, 3, 20));
    }

    public GarminRouteD201(GarminPacket pack) {
        this.setIdentification(Integer.toString(pack.getNextAsByte()));
        this.setComment(pack.getNextAsString(20));
    }

    public GarminRouteD201(GPSRoute route) {
        String tmp = route.getIdentification();
        this.setIdentification(tmp == null ? "" : tmp);
        tmp = route.getComment();
        this.setComment(tmp == null ? "" : tmp);
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 21;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        try {
            byte id = Byte.parseByte(this.getIdentification());
            pack.setNextAsByte(id);
            pack.setNextAsString(this.getComment(), 20, false);
        }
        catch (NumberFormatException nfe) {
            byte by = route_id_;
            route_id_ = (byte)(by + 1);
            byte id = by;
            pack.setNextAsByte(id);
            pack.setNextAsString(this.getIdentification(), 20, false);
        }
        return pack;
    }
}

