/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.util.darknet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.zoo.util.BaseLabels;

public class DarknetLabels
extends BaseLabels {
    private boolean shortNames;
    private int numClasses;

    public DarknetLabels() throws IOException {
        this(true);
    }

    public DarknetLabels(int numClasses) throws IOException {
        this(true, numClasses);
    }

    @Override
    protected URL getURL() {
        try {
            if (this.shortNames) {
                return DL4JResources.getURL((String)"resources/darknet/imagenet.shortnames.list");
            }
            return DL4JResources.getURL((String)"resources/darknet/imagenet.labels.list");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public DarknetLabels(boolean shortnames) throws IOException {
        this(shortnames, 1000);
    }

    public DarknetLabels(boolean shortnames, int numClasses) throws IOException {
        this.shortNames = shortnames;
        this.numClasses = numClasses;
        ArrayList<String> labels = this.getLabels(shortnames ? "imagenet.shortnames.list" : "imagenet.labels.list");
        this.labels = new ArrayList();
        for (int i = 0; i < numClasses; ++i) {
            this.labels.add((String)labels.get(i));
        }
    }

    @Override
    protected String resourceName() {
        return "darknet";
    }

    @Override
    protected String resourceMD5() {
        if (this.shortNames) {
            return "23d2a102a2de03d1b169c748b7141a20";
        }
        return "23ab429a707492324fef60a933551941";
    }
}

