/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights;

import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class WeightInitVarScalingUniformFanIn
implements IWeightInit {
    private Double scale;

    public WeightInitVarScalingUniformFanIn(Double scale) {
        this.scale = scale;
    }

    @Override
    public INDArray init(double fanIn, double fanOut, long[] shape, char order, INDArray paramView) {
        double scalingFanIn = 3.0 / Math.sqrt(fanIn);
        if (this.scale != null) {
            scalingFanIn *= this.scale.doubleValue();
        }
        Nd4j.rand((INDArray)paramView, (Distribution)Nd4j.getDistributions().createUniform(-scalingFanIn, scalingFanIn));
        return paramView.reshape(order, shape);
    }

    public WeightInitVarScalingUniformFanIn() {
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightInitVarScalingUniformFanIn)) {
            return false;
        }
        WeightInitVarScalingUniformFanIn other = (WeightInitVarScalingUniformFanIn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$scale = this.getScale();
        Double other$scale = other.getScale();
        return !(this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightInitVarScalingUniformFanIn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        return result;
    }

    public String toString() {
        return "WeightInitVarScalingUniformFanIn(scale=" + this.getScale() + ")";
    }
}

