/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.updater;

import java.util.HashMap;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Trainable;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.updater.BaseMultiLayerUpdater;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerUpdater
extends BaseMultiLayerUpdater<Layer> {
    private static final Logger log = LoggerFactory.getLogger(LayerUpdater.class);

    public LayerUpdater(Layer layer) {
        this(layer, (INDArray)null);
    }

    public LayerUpdater(Layer layer, INDArray updaterState) {
        super(layer, updaterState);
        if (layer instanceof MultiLayerNetwork) {
            throw new UnsupportedOperationException("Cannot use LayerUpdater for a MultiLayerNetwork");
        }
        this.layersByName = new HashMap();
        this.layersByName.put(layer.conf().getLayer().getLayerName(), layer);
    }

    @Override
    protected Trainable[] getOrderedLayers() {
        return new Trainable[]{(Trainable)((Object)this.network)};
    }

    @Override
    protected INDArray getFlattenedGradientsView() {
        return ((Layer)this.network).getGradientsViewArray();
    }

    @Override
    protected INDArray getParams() {
        return ((Layer)this.network).params();
    }

    @Override
    protected boolean isMiniBatch() {
        return ((Layer)this.network).conf().isMiniBatch();
    }

    @Override
    protected boolean isSingleLayerUpdater() {
        return true;
    }
}

