/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.upsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling2D
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.Upsampling2D> {
    private static final Logger log = LoggerFactory.getLogger(Upsampling2D.class);

    public Upsampling2D(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.UPSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        this.assertInputSet(true);
        CNN2DFormat format = this.getFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        long miniBatch = (int)this.input.size(0);
        long inDepth = (int)this.input.size(nchw ? 1 : 3);
        long inH = (int)this.input.size(nchw ? 2 : 1);
        long inW = (int)this.input.size(nchw ? 3 : 2);
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = inDepth;
            lArray2[2] = inH;
            lArray = lArray2;
            lArray2[3] = inW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = inH;
            lArray3[2] = inW;
            lArray = lArray3;
            lArray3[3] = inDepth;
        }
        long[] epsShape = lArray;
        INDArray epsOut = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, epsilon.dataType(), epsShape, 'c');
        DefaultGradient gradient = new DefaultGradient();
        DynamicCustomOp op = DynamicCustomOp.builder((String)"upsampling_bp").addIntegerArguments(nchw ? 1L : 0L).addInputs(new INDArray[]{this.input, epsilon}).addOutputs(new INDArray[]{epsOut}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        epsOut = this.backpropDropOutIfPresent(epsOut);
        return new Pair((Object)gradient, (Object)epsOut);
    }

    protected int[] getSize() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling2D)this.layerConf()).getSize();
    }

    protected CNN2DFormat getFormat() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling2D)this.layerConf()).getFormat();
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((org.deeplearning4j.nn.conf.layers.Upsampling2D)this.layerConf()).getFormat().dimensionNames() + ". " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        CNN2DFormat format = this.getFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        long miniBatch = (int)this.input.size(0);
        long inDepth = (int)this.input.size(nchw ? 1 : 3);
        long inH = (int)this.input.size(nchw ? 2 : 1);
        long inW = (int)this.input.size(nchw ? 3 : 2);
        int[] size = this.getSize();
        int outH = (int)inH * size[0];
        int outW = (int)inW * size[1];
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = inDepth;
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = inDepth;
        }
        long[] outShape = lArray;
        INDArray reshapedOutput = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        int[] intArgs = new int[]{size[0], size[1], nchw ? 1 : 0};
        DynamicCustomOp upsampling = DynamicCustomOp.builder((String)"upsampling2d").addIntegerArguments(intArgs).addInputs(new INDArray[]{this.input}).addOutputs(new INDArray[]{reshapedOutput}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)upsampling);
        return reshapedOutput;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        INDArray z = this.preOutput(training, false, workspaceMgr);
        if (training && this.cacheMode != CacheMode.NONE && workspaceMgr.hasConfiguration(ArrayType.FF_CACHE) && workspaceMgr.isWorkspaceOpen(ArrayType.FF_CACHE)) {
            try (MemoryWorkspace wsB = workspaceMgr.notifyScopeBorrowed(ArrayType.FF_CACHE);){
                this.preOutput = z.unsafeDuplication();
            }
        }
        return z;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

