/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;

public class Deconvolution2DLayer
extends ConvolutionLayer {
    public Deconvolution2DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] opOutputs;
        INDArray[] opInputs;
        long[] lArray;
        int[] pad;
        this.assertInputSet(true);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Deconvolution2DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat().dimensionNames() + ". " + this.layerId());
        }
        INDArray weights = this.getParamWithNoise("W", true, workspaceMgr);
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        int hDim = nchw ? 2 : 1;
        int wDim = nchw ? 3 : 2;
        long miniBatch = this.input.size(0);
        long inH = this.input.size(hDim);
        long inW = this.input.size(wDim);
        long inDepth = weights.size(0);
        long kH = weights.size(2);
        long kW = weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = new int[]{(int)epsilon.size(hDim), (int)epsilon.size(wDim)};
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{(int)inH, (int)inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
        }
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = inDepth;
            lArray2[2] = inH;
            lArray = lArray2;
            lArray2[3] = inW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = inH;
            lArray3[2] = inW;
            lArray = lArray3;
            lArray3[3] = inDepth;
        }
        long[] epsShape = lArray;
        INDArray outEps = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, weights.dataType(), epsShape, 'c');
        Integer sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{(int)kH, (int)kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, nchw ? 0 : 1};
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        weights = weights.permute(new int[]{2, 3, 1, 0});
        INDArray weightGradViewOp = weightGradView.permute(new int[]{2, 3, 1, 0});
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            opInputs = new INDArray[]{this.input, weights, bias, delta};
            opOutputs = new INDArray[]{outEps, weightGradViewOp, biasGradView};
        } else {
            opInputs = new INDArray[]{this.input, weights, delta};
            opOutputs = new INDArray[]{outEps, weightGradViewOp};
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"deconv2d_bp").addInputs(opInputs).addIntegerArguments(args).addOutputs(opOutputs).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        return new Pair((Object)retGradient, (Object)outEps);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        int[] pad;
        int[] outSize;
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray weights = this.getParamWithNoise("W", training, workspaceMgr);
        if (this.input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Deconvolution2D (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, layerInputDepth, inputHeight, inputWidth]." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        int cDim = nchw ? 1 : 3;
        int hDim = nchw ? 2 : 1;
        int wDim = nchw ? 3 : 2;
        long inDepth = weights.size(0);
        long outDepth = weights.size(1);
        if (this.input.size(cDim) != inDepth) {
            int dimIfWrongFormat;
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            String s = "Cannot do forward pass in Deconvolution2D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data format = " + format + ", data input channels = " + this.input.size(cDim) + ", " + (nchw ? "[minibatch,inputDepth,height,width]" : "[minibatch,height,width,inputDepth]") + "=" + Arrays.toString(this.input.shape()) + "; expected input channels = " + inDepth + ") " + this.layerId();
            int n = dimIfWrongFormat = format == CNN2DFormat.NHWC ? 1 : 3;
            if (this.input.size(dimIfWrongFormat) == inDepth) {
                s = s + "\nNote: Convolution layers can be configured for either NCHW (channels first) or NHWC (channels last) format for input images and activations.\nLayers can be configured using .dataFormat(CNN2DFormat.NCHW/NHWC) when constructing the layer, or for the entire net using .setInputType(InputType.convolutional(height, width, depth, CNN2DForman.NCHW/NHWC)).\nImageRecordReader and NativeImageLoader can also be configured to load image data in either NCHW or NHWC format which must match the network";
            }
            throw new DL4JInvalidInputException(s);
        }
        int kH = (int)weights.size(2);
        int kW = (int)weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, format);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{(int)this.input.size(hDim), (int)this.input.size(wDim)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation, format);
        }
        long outH = outSize[0];
        long outW = outSize[1];
        long miniBatch = this.input.size(0);
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = outDepth;
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = outDepth;
        }
        long[] outShape = lArray;
        INDArray output = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        int sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, nchw ? 0 : 1};
        weights = weights.permute(new int[]{2, 3, 1, 0});
        INDArray[] opInputs = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias() ? new INDArray[]{this.input, weights, bias} : new INDArray[]{this.input, weights};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"deconv2d").addInputs(opInputs).addIntegerArguments(args).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)output, null);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray ret;
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        if (this.helper != null && Shape.strideDescendingCAscendingF((INDArray)z) && (ret = this.helper.activate(z, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn(), training)) != null) {
            return ret;
        }
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }
}

