/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.weightnoise;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.MulOp;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class WeightNoise
implements IWeightNoise {
    private org.deeplearning4j.nn.conf.distribution.Distribution distribution;
    private boolean applyToBias;
    private boolean additive;

    public WeightNoise(org.deeplearning4j.nn.conf.distribution.Distribution distribution) {
        this(distribution, false, true);
    }

    public WeightNoise(org.deeplearning4j.nn.conf.distribution.Distribution distribution, boolean additive) {
        this(distribution, false, additive);
    }

    public WeightNoise(@JsonProperty(value="distribution") org.deeplearning4j.nn.conf.distribution.Distribution distribution, @JsonProperty(value="applyToBias") boolean applyToBias, @JsonProperty(value="additive") boolean additive) {
        this.distribution = distribution;
        this.applyToBias = applyToBias;
        this.additive = additive;
    }

    @Override
    public INDArray getParameter(Layer layer, String paramKey, int iteration, int epoch, boolean train, LayerWorkspaceMgr workspaceMgr) {
        ParamInitializer init = layer.conf().getLayer().initializer();
        INDArray param = layer.getParam(paramKey);
        if (train && init.isWeightParam(layer.conf().getLayer(), paramKey) || this.applyToBias && init.isBiasParam(layer.conf().getLayer(), paramKey)) {
            Distribution dist = Distributions.createDistribution(this.distribution);
            INDArray noise = dist.sample(param.ulike());
            INDArray out = workspaceMgr.createUninitialized(ArrayType.INPUT, param.dataType(), param.shape(), param.ordering());
            if (this.additive) {
                Nd4j.getExecutioner().exec((CustomOp)new AddOp(param, noise, out));
            } else {
                Nd4j.getExecutioner().exec((CustomOp)new MulOp(param, noise, out));
            }
            return out;
        }
        return param;
    }

    @Override
    public WeightNoise clone() {
        return new WeightNoise(this.distribution, this.applyToBias, this.additive);
    }

    public org.deeplearning4j.nn.conf.distribution.Distribution getDistribution() {
        return this.distribution;
    }

    public boolean isApplyToBias() {
        return this.applyToBias;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setDistribution(org.deeplearning4j.nn.conf.distribution.Distribution distribution) {
        this.distribution = distribution;
    }

    public void setApplyToBias(boolean applyToBias) {
        this.applyToBias = applyToBias;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightNoise)) {
            return false;
        }
        WeightNoise other = (WeightNoise)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.deeplearning4j.nn.conf.distribution.Distribution this$distribution = this.getDistribution();
        org.deeplearning4j.nn.conf.distribution.Distribution other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        if (this.isApplyToBias() != other.isApplyToBias()) {
            return false;
        }
        return this.isAdditive() == other.isAdditive();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightNoise;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.deeplearning4j.nn.conf.distribution.Distribution $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        result = result * 59 + (this.isApplyToBias() ? 79 : 97);
        result = result * 59 + (this.isAdditive() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "WeightNoise(distribution=" + this.getDistribution() + ", applyToBias=" + this.isApplyToBias() + ", additive=" + this.isAdditive() + ")";
    }
}

