/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class MergeVertex
extends GraphVertex {
    protected int mergeAxis = 1;

    @Override
    public MergeVertex clone() {
        return new MergeVertex();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MergeVertex;
    }

    @Override
    public int hashCode() {
        return 433682566;
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 2;
    }

    @Override
    public int maxVertexInputs() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "MergeVertex()";
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        return new org.deeplearning4j.nn.graph.vertex.impl.MergeVertex(graph, name, idx, networkDatatype, this.mergeAxis);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        if (first.getType() == InputType.Type.CNNFlat) {
            throw new InvalidInputTypeException("Invalid input: MergeVertex cannot currently merge CNN data in flattened format. Got: " + vertexInputs);
        }
        if (first.getType() == InputType.Type.CNN3D) {
            long fc;
            InputType.InputTypeConvolutional3D firstConv = (InputType.InputTypeConvolutional3D)first;
            long fd = firstConv.getDepth();
            long fw = firstConv.getWidth();
            long fh = firstConv.getHeight();
            long depthSum = fc = firstConv.getChannels();
            InputType.InputTypeConvolutional3D otherConv = null;
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() != InputType.Type.CNN3D) {
                    throw new InvalidInputTypeException("Invalid input: MergeVertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN3D) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                otherConv = (InputType.InputTypeConvolutional3D)vertexInputs[i];
                long od = otherConv.getDepth();
                long ow = otherConv.getWidth();
                long oh = otherConv.getHeight();
                long oc = otherConv.getChannels();
                if (fd != od || fw != ow || fh != oh) {
                    throw new InvalidInputTypeException("Invalid input: MergeVertex cannot merge CNN3D activations of different width/heights:first [channels,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
                }
                depthSum += oc;
            }
            return InputType.convolutional3D(Convolution3D.DataFormat.NDHWC, fd, fh, fw, depthSum);
        }
        if (first.getType() != InputType.Type.CNN) {
            int size = 0;
            InputType.Type type = null;
            RNNFormat format = null;
            for (int i = 0; i < vertexInputs.length; ++i) {
                long thisSize;
                if (vertexInputs[i].getType() != first.getType()) {
                    throw new InvalidInputTypeException("Invalid input: MergeVertex cannot merge activations of different types: first type = " + (Object)((Object)first.getType()) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                switch (vertexInputs[i].getType()) {
                    case FF: {
                        thisSize = ((InputType.InputTypeFeedForward)vertexInputs[i]).getSize();
                        type = InputType.Type.FF;
                        break;
                    }
                    case RNN: {
                        thisSize = ((InputType.InputTypeRecurrent)vertexInputs[i]).getSize();
                        format = ((InputType.InputTypeRecurrent)vertexInputs[i]).getFormat();
                        this.mergeAxis = format == RNNFormat.NCW ? 1 : 2;
                        type = InputType.Type.RNN;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown input type: " + vertexInputs[i]);
                    }
                }
                size = thisSize <= 0L ? -1 : (int)((long)size + thisSize);
            }
            if (size > 0) {
                if (type == InputType.Type.FF) {
                    return InputType.feedForward(size);
                }
                long tsLength = ((InputType.InputTypeRecurrent)vertexInputs[0]).getTimeSeriesLength();
                return InputType.recurrent(size, tsLength, format);
            }
            if (type == InputType.Type.FF) {
                return InputType.feedForward(-1L);
            }
            long tsLength = ((InputType.InputTypeRecurrent)vertexInputs[0]).getTimeSeriesLength();
            return InputType.recurrent(-1L, tsLength, format);
        }
        InputType.InputTypeConvolutional firstConv = (InputType.InputTypeConvolutional)first;
        CNN2DFormat format = firstConv.getFormat();
        long fd = firstConv.getChannels();
        long fw = firstConv.getWidth();
        long fh = firstConv.getHeight();
        long depthSum = fd;
        for (int i = 1; i < vertexInputs.length; ++i) {
            if (vertexInputs[i].getType() != InputType.Type.CNN) {
                throw new InvalidInputTypeException("Invalid input: MergeVertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
            }
            InputType.InputTypeConvolutional otherConv = (InputType.InputTypeConvolutional)vertexInputs[i];
            long od = otherConv.getChannels();
            long ow = otherConv.getWidth();
            long oh = otherConv.getHeight();
            if (fw != ow || fh != oh) {
                throw new InvalidInputTypeException("Invalid input: MergeVertex cannot merge CNN activations of different width/heights:first [channels,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
            }
            depthSum += od;
        }
        this.mergeAxis = format == CNN2DFormat.NCHW ? 1 : 3;
        return InputType.convolutional(fh, fw, depthSum, format);
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, MergeVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }
}

