/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.saver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.util.ModelSerializer;

public class LocalFileGraphSaver
implements EarlyStoppingModelSaver<ComputationGraph> {
    private static final String BEST_GRAPH_BIN = "bestGraph.bin";
    private static final String LATEST_GRAPH_BIN = "latestGraph.bin";
    private String directory;
    private Charset encoding;

    public LocalFileGraphSaver(String directory) {
        this(directory, Charset.defaultCharset());
    }

    public LocalFileGraphSaver(String directory, Charset encoding) {
        this.directory = directory;
        this.encoding = encoding;
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @Override
    public void saveBestModel(ComputationGraph net, double score) throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)BEST_GRAPH_BIN);
        this.save(net, confOut);
    }

    @Override
    public void saveLatestModel(ComputationGraph net, double score) throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)LATEST_GRAPH_BIN);
        this.save(net, confOut);
    }

    private void save(ComputationGraph net, String confOut) throws IOException {
        ModelSerializer.writeModel((Model)net, confOut, true);
    }

    @Override
    public ComputationGraph getBestModel() throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)BEST_GRAPH_BIN);
        return this.load(confOut);
    }

    @Override
    public ComputationGraph getLatestModel() throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)LATEST_GRAPH_BIN);
        return this.load(confOut);
    }

    private ComputationGraph load(String confOut) throws IOException {
        ComputationGraph net = ModelSerializer.restoreComputationGraph(confOut);
        return net;
    }

    public String toString() {
        return "LocalFileGraphSaver(dir=" + this.directory + ")";
    }
}

