/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.earlystopping.saver.InMemoryModelSaver;
import org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator;
import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.nn.api.Model;
import org.nd4j.common.function.Supplier;

public class EarlyStoppingConfiguration<T extends Model>
implements Serializable {
    private EarlyStoppingModelSaver<T> modelSaver;
    private List<EpochTerminationCondition> epochTerminationConditions;
    private List<IterationTerminationCondition> iterationTerminationConditions;
    private boolean saveLastModel;
    private int evaluateEveryNEpochs;
    private ScoreCalculator<T> scoreCalculator;
    private Supplier<ScoreCalculator> scoreCalculatorSupplier;

    private EarlyStoppingConfiguration(Builder<T> builder) {
        this.modelSaver = ((Builder)builder).modelSaver;
        this.epochTerminationConditions = ((Builder)builder).epochTerminationConditions;
        this.iterationTerminationConditions = ((Builder)builder).iterationTerminationConditions;
        this.saveLastModel = ((Builder)builder).saveLastModel;
        this.evaluateEveryNEpochs = ((Builder)builder).evaluateEveryNEpochs;
        this.scoreCalculator = ((Builder)builder).scoreCalculator;
        this.scoreCalculatorSupplier = ((Builder)builder).scoreCalculatorSupplier;
    }

    public ScoreCalculator<T> getScoreCalculator() {
        if (this.scoreCalculatorSupplier != null) {
            return (ScoreCalculator)this.scoreCalculatorSupplier.get();
        }
        return this.scoreCalculator;
    }

    public void validate() {
        if (this.scoreCalculator == null && this.scoreCalculatorSupplier == null) {
            throw new DL4JInvalidConfigException("A score calculator or score calculator supplier must be defined.");
        }
        if (this.modelSaver == null) {
            throw new DL4JInvalidConfigException("A model saver must be defined");
        }
        boolean hasTermination = false;
        if (this.iterationTerminationConditions != null && !this.iterationTerminationConditions.isEmpty()) {
            hasTermination = true;
        } else if (this.epochTerminationConditions != null && !this.epochTerminationConditions.isEmpty()) {
            hasTermination = true;
        }
        if (!hasTermination) {
            throw new DL4JInvalidConfigException("No termination conditions defined.");
        }
    }

    public EarlyStoppingModelSaver<T> getModelSaver() {
        return this.modelSaver;
    }

    public List<EpochTerminationCondition> getEpochTerminationConditions() {
        return this.epochTerminationConditions;
    }

    public List<IterationTerminationCondition> getIterationTerminationConditions() {
        return this.iterationTerminationConditions;
    }

    public boolean isSaveLastModel() {
        return this.saveLastModel;
    }

    public int getEvaluateEveryNEpochs() {
        return this.evaluateEveryNEpochs;
    }

    public Supplier<ScoreCalculator> getScoreCalculatorSupplier() {
        return this.scoreCalculatorSupplier;
    }

    public void setModelSaver(EarlyStoppingModelSaver<T> modelSaver) {
        this.modelSaver = modelSaver;
    }

    public void setEpochTerminationConditions(List<EpochTerminationCondition> epochTerminationConditions) {
        this.epochTerminationConditions = epochTerminationConditions;
    }

    public void setIterationTerminationConditions(List<IterationTerminationCondition> iterationTerminationConditions) {
        this.iterationTerminationConditions = iterationTerminationConditions;
    }

    public void setSaveLastModel(boolean saveLastModel) {
        this.saveLastModel = saveLastModel;
    }

    public void setEvaluateEveryNEpochs(int evaluateEveryNEpochs) {
        this.evaluateEveryNEpochs = evaluateEveryNEpochs;
    }

    public void setScoreCalculator(ScoreCalculator<T> scoreCalculator) {
        this.scoreCalculator = scoreCalculator;
    }

    public void setScoreCalculatorSupplier(Supplier<ScoreCalculator> scoreCalculatorSupplier) {
        this.scoreCalculatorSupplier = scoreCalculatorSupplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyStoppingConfiguration)) {
            return false;
        }
        EarlyStoppingConfiguration other = (EarlyStoppingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EarlyStoppingModelSaver<T> this$modelSaver = this.getModelSaver();
        EarlyStoppingModelSaver<T> other$modelSaver = other.getModelSaver();
        if (this$modelSaver == null ? other$modelSaver != null : !this$modelSaver.equals(other$modelSaver)) {
            return false;
        }
        List<EpochTerminationCondition> this$epochTerminationConditions = this.getEpochTerminationConditions();
        List<EpochTerminationCondition> other$epochTerminationConditions = other.getEpochTerminationConditions();
        if (this$epochTerminationConditions == null ? other$epochTerminationConditions != null : !((Object)this$epochTerminationConditions).equals(other$epochTerminationConditions)) {
            return false;
        }
        List<IterationTerminationCondition> this$iterationTerminationConditions = this.getIterationTerminationConditions();
        List<IterationTerminationCondition> other$iterationTerminationConditions = other.getIterationTerminationConditions();
        if (this$iterationTerminationConditions == null ? other$iterationTerminationConditions != null : !((Object)this$iterationTerminationConditions).equals(other$iterationTerminationConditions)) {
            return false;
        }
        if (this.isSaveLastModel() != other.isSaveLastModel()) {
            return false;
        }
        if (this.getEvaluateEveryNEpochs() != other.getEvaluateEveryNEpochs()) {
            return false;
        }
        ScoreCalculator<T> this$scoreCalculator = this.getScoreCalculator();
        ScoreCalculator<T> other$scoreCalculator = other.getScoreCalculator();
        if (this$scoreCalculator == null ? other$scoreCalculator != null : !this$scoreCalculator.equals(other$scoreCalculator)) {
            return false;
        }
        Supplier<ScoreCalculator> this$scoreCalculatorSupplier = this.getScoreCalculatorSupplier();
        Supplier<ScoreCalculator> other$scoreCalculatorSupplier = other.getScoreCalculatorSupplier();
        return !(this$scoreCalculatorSupplier == null ? other$scoreCalculatorSupplier != null : !this$scoreCalculatorSupplier.equals(other$scoreCalculatorSupplier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EarlyStoppingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EarlyStoppingModelSaver<T> $modelSaver = this.getModelSaver();
        result = result * 59 + ($modelSaver == null ? 43 : $modelSaver.hashCode());
        List<EpochTerminationCondition> $epochTerminationConditions = this.getEpochTerminationConditions();
        result = result * 59 + ($epochTerminationConditions == null ? 43 : ((Object)$epochTerminationConditions).hashCode());
        List<IterationTerminationCondition> $iterationTerminationConditions = this.getIterationTerminationConditions();
        result = result * 59 + ($iterationTerminationConditions == null ? 43 : ((Object)$iterationTerminationConditions).hashCode());
        result = result * 59 + (this.isSaveLastModel() ? 79 : 97);
        result = result * 59 + this.getEvaluateEveryNEpochs();
        ScoreCalculator<T> $scoreCalculator = this.getScoreCalculator();
        result = result * 59 + ($scoreCalculator == null ? 43 : $scoreCalculator.hashCode());
        Supplier<ScoreCalculator> $scoreCalculatorSupplier = this.getScoreCalculatorSupplier();
        result = result * 59 + ($scoreCalculatorSupplier == null ? 43 : $scoreCalculatorSupplier.hashCode());
        return result;
    }

    public String toString() {
        return "EarlyStoppingConfiguration(modelSaver=" + this.getModelSaver() + ", epochTerminationConditions=" + this.getEpochTerminationConditions() + ", iterationTerminationConditions=" + this.getIterationTerminationConditions() + ", saveLastModel=" + this.isSaveLastModel() + ", evaluateEveryNEpochs=" + this.getEvaluateEveryNEpochs() + ", scoreCalculator=" + this.getScoreCalculator() + ", scoreCalculatorSupplier=" + this.getScoreCalculatorSupplier() + ")";
    }

    public EarlyStoppingConfiguration() {
    }

    public static class Builder<T extends Model> {
        private EarlyStoppingModelSaver<T> modelSaver = new InMemoryModelSaver();
        private List<EpochTerminationCondition> epochTerminationConditions = new ArrayList<EpochTerminationCondition>();
        private List<IterationTerminationCondition> iterationTerminationConditions = new ArrayList<IterationTerminationCondition>();
        private boolean saveLastModel = false;
        private int evaluateEveryNEpochs = 1;
        private ScoreCalculator<T> scoreCalculator;
        private Supplier<ScoreCalculator> scoreCalculatorSupplier;

        public Builder<T> modelSaver(EarlyStoppingModelSaver<T> modelSaver) {
            this.modelSaver = modelSaver;
            return this;
        }

        public Builder<T> epochTerminationConditions(EpochTerminationCondition ... terminationConditions) {
            this.epochTerminationConditions.clear();
            Collections.addAll(this.epochTerminationConditions, terminationConditions);
            return this;
        }

        public Builder<T> epochTerminationConditions(List<EpochTerminationCondition> terminationConditions) {
            this.epochTerminationConditions = terminationConditions;
            return this;
        }

        public Builder<T> iterationTerminationConditions(IterationTerminationCondition ... terminationConditions) {
            this.iterationTerminationConditions.clear();
            Collections.addAll(this.iterationTerminationConditions, terminationConditions);
            return this;
        }

        public Builder<T> saveLastModel(boolean saveLastModel) {
            this.saveLastModel = saveLastModel;
            return this;
        }

        public Builder<T> evaluateEveryNEpochs(int everyNEpochs) {
            this.evaluateEveryNEpochs = everyNEpochs;
            return this;
        }

        public Builder<T> scoreCalculator(ScoreCalculator scoreCalculator) {
            this.scoreCalculator = scoreCalculator;
            return this;
        }

        public Builder<T> scoreCalculator(Supplier<ScoreCalculator> scoreCalculatorSupplier) {
            this.scoreCalculatorSupplier = scoreCalculatorSupplier;
            return this;
        }

        public EarlyStoppingConfiguration<T> build() {
            return new EarlyStoppingConfiguration(this);
        }
    }
}

