/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.pooling;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Subsampling1DLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPoolingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasPooling1D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasPooling1D.class);

    public KerasPooling1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasPooling1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Subsampling1DLayer.Builder builder = ((Subsampling1DLayer.Builder)((Subsampling1DLayer.Builder)((Subsampling1DLayer.Builder)new Subsampling1DLayer.Builder(KerasPoolingUtils.mapPoolingType(this.className, this.conf)).name(this.layerName)).dropOut(this.dropout)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 1, this.conf, this.kerasMajorVersion)[0]).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 1, this.conf)[0]);
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 1, this.conf, this.kerasMajorVersion);
        if (padding != null) {
            builder.padding(padding[0]);
        }
        this.layer = builder.build();
        this.vertex = null;
    }

    public Subsampling1DLayer getSubsampling1DLayer() {
        return (Subsampling1DLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Subsampling 1D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSubsampling1DLayer().getOutputType(-1, inputType[0]);
    }
}

