/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.listener;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.json.SystemInfo;

public class SystemInfoFilePrintListener
implements TrainingListener {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoFilePrintListener.class);
    private boolean printOnEpochStart;
    private boolean printOnEpochEnd;
    private boolean printOnForwardPass;
    private boolean printOnBackwardPass;
    private boolean printOnGradientCalculation;
    private File printFileTarget;

    public SystemInfoFilePrintListener(boolean printOnEpochStart, boolean printOnEpochEnd, boolean printOnForwardPass, boolean printOnBackwardPass, boolean printOnGradientCalculation, @NonNull File printFileTarget) {
        if (printFileTarget == null) {
            throw new NullPointerException("printFileTarget is marked non-null but is null");
        }
        this.printOnEpochStart = printOnEpochStart;
        this.printOnEpochEnd = printOnEpochEnd;
        this.printOnForwardPass = printOnForwardPass;
        this.printOnBackwardPass = printOnBackwardPass;
        this.printOnGradientCalculation = printOnGradientCalculation;
        this.printFileTarget = printFileTarget;
    }

    public void iterationDone(Model model, int iteration, int epoch) {
    }

    public void onEpochStart(Model model) {
        if (!this.printOnEpochStart || this.printFileTarget == null) {
            return;
        }
        this.writeFileWithMessage("epoch end");
    }

    public void onEpochEnd(Model model) {
        if (!this.printOnEpochEnd || this.printFileTarget == null) {
            return;
        }
        this.writeFileWithMessage("epoch begin");
    }

    public void onForwardPass(Model model, List<INDArray> activations) {
        if (!this.printOnBackwardPass || this.printFileTarget == null) {
            return;
        }
        this.writeFileWithMessage("forward pass");
    }

    public void onForwardPass(Model model, Map<String, INDArray> activations) {
        if (!this.printOnForwardPass || this.printFileTarget == null) {
            return;
        }
        this.writeFileWithMessage("forward pass");
    }

    public void onGradientCalculation(Model model) {
        if (!this.printOnGradientCalculation || this.printFileTarget == null) {
            return;
        }
        this.writeFileWithMessage("gradient calculation");
    }

    public void onBackwardPass(Model model) {
        if (!this.printOnBackwardPass || this.printFileTarget == null) {
            return;
        }
        this.writeFileWithMessage("backward pass");
    }

    private void writeFileWithMessage(String status) {
        if (this.printFileTarget == null) {
            log.warn("File not specified for writing!");
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info("Writing system info to file on " + status + ": " + this.printFileTarget.getAbsolutePath());
        try {
            FileUtils.write((File)this.printFileTarget, (CharSequence)systemInfo.toPrettyJSON(), (boolean)true);
        }
        catch (IOException e) {
            log.error("Error writing file for system info", (Throwable)e);
        }
    }

    public static SystemInfoFilePrintListenerBuilder builder() {
        return new SystemInfoFilePrintListenerBuilder();
    }

    public static class SystemInfoFilePrintListenerBuilder {
        private boolean printOnEpochStart;
        private boolean printOnEpochEnd;
        private boolean printOnForwardPass;
        private boolean printOnBackwardPass;
        private boolean printOnGradientCalculation;
        private File printFileTarget;

        SystemInfoFilePrintListenerBuilder() {
        }

        public SystemInfoFilePrintListenerBuilder printOnEpochStart(boolean printOnEpochStart) {
            this.printOnEpochStart = printOnEpochStart;
            return this;
        }

        public SystemInfoFilePrintListenerBuilder printOnEpochEnd(boolean printOnEpochEnd) {
            this.printOnEpochEnd = printOnEpochEnd;
            return this;
        }

        public SystemInfoFilePrintListenerBuilder printOnForwardPass(boolean printOnForwardPass) {
            this.printOnForwardPass = printOnForwardPass;
            return this;
        }

        public SystemInfoFilePrintListenerBuilder printOnBackwardPass(boolean printOnBackwardPass) {
            this.printOnBackwardPass = printOnBackwardPass;
            return this;
        }

        public SystemInfoFilePrintListenerBuilder printOnGradientCalculation(boolean printOnGradientCalculation) {
            this.printOnGradientCalculation = printOnGradientCalculation;
            return this;
        }

        public SystemInfoFilePrintListenerBuilder printFileTarget(File printFileTarget) {
            this.printFileTarget = printFileTarget;
            return this;
        }

        public SystemInfoFilePrintListener build() {
            return new SystemInfoFilePrintListener(this.printOnEpochStart, this.printOnEpochEnd, this.printOnForwardPass, this.printOnBackwardPass, this.printOnGradientCalculation, this.printFileTarget);
        }

        public String toString() {
            return "SystemInfoFilePrintListener.SystemInfoFilePrintListenerBuilder(printOnEpochStart=" + this.printOnEpochStart + ", printOnEpochEnd=" + this.printOnEpochEnd + ", printOnForwardPass=" + this.printOnForwardPass + ", printOnBackwardPass=" + this.printOnBackwardPass + ", printOnGradientCalculation=" + this.printOnGradientCalculation + ", printFileTarget=" + this.printFileTarget + ")";
        }
    }
}

