/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.jpa;

import org.datanucleus.StateManager;
import org.datanucleus.store.fieldmanager.FieldConsumer;
import org.datanucleus.store.fieldmanager.FieldSupplier;

/**
 * Standard interface that any class that is persistable should implement when not using JDO.
 * Based roughly on the javax.jdo.spi.PersistenceCapable.
 */
public interface Persistable
{
    static final byte READ_WRITE_OK = 0;
    static final byte LOAD_REQUIRED = 1;
    static final byte READ_OK = -1;
    static final byte CHECK_READ = 1;
    static final byte MEDIATE_READ = 2;
    static final byte CHECK_WRITE = 4;
    static final byte MEDIATE_WRITE = 8;
    static final byte SERIALIZABLE = 16;

    StateManager jpoxGetStateManager();

    void jpoxReplaceStateManager(StateManager sm) throws SecurityException;

    void jpoxProvideField(int fieldNumber);
    void jpoxProvideFields(int[] fieldNumbers);
    void jpoxReplaceField(int fieldNumber);
    void jpoxReplaceFields(int[] fieldNumbers);
    void jpoxReplaceFlags();
    void jpoxCopyFields(Object other, int[] fieldNumbers);
    void jpoxMakeDirty(String fieldName);

    Object jpoxGetObjectId();
    Object jpoxGetTransactionalObjectId();
    Object jpoxGetVersion();
    boolean jpoxIsDirty();
    boolean jpoxIsTransactional();
    boolean jpoxIsPersistent();
    boolean jpoxIsNew();
    boolean jpoxIsDeleted();
    boolean jpoxIsDetached();

    Persistable jpoxNewInstance(StateManager sm);
    Persistable jpoxNewInstance(StateManager sm, Object oid);

    Object jpoxNewObjectIdInstance();
    Object jpoxNewObjectIdInstance(Object o);
    void jpoxCopyKeyFieldsToObjectId(Object oid);
    void jpoxCopyKeyFieldsToObjectId(FieldSupplier fm, Object oid);
    void jpoxCopyKeyFieldsFromObjectId(FieldConsumer fm, Object oid);

    void jpoxReplaceDetachedState();
}