/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.model.Attribute;
import org.cyclonedx.model.ExtensibleType;

public class ExtensibleTypesSerializer
extends StdSerializer<List<ExtensibleType>> {
    private final String XMLNS = "xmlns";

    public ExtensibleTypesSerializer() {
        this(null);
    }

    public ExtensibleTypesSerializer(Class<List<ExtensibleType>> t) {
        super(t);
    }

    public void serialize(List<ExtensibleType> extensibleTypes, JsonGenerator generator, SerializerProvider provider) throws IOException {
        ToXmlGenerator toXmlGenerator = (ToXmlGenerator)generator;
        XMLStreamWriter staxWriter = toXmlGenerator.getStaxWriter();
        try {
            if (CollectionUtils.isNotEmpty(extensibleTypes)) {
                for (ExtensibleType ext : extensibleTypes) {
                    if (CollectionUtils.isNotEmpty(ext.getAttributes())) {
                        Attribute xmlNS = ext.getAttributes().stream().filter(a -> a.getKey().contains("xmlns")).findAny().orElse(null);
                        if (xmlNS != null) {
                            staxWriter.writeStartElement(ext.getNamespace(), ext.getName(), xmlNS.getValue());
                            for (Attribute attr : ext.getAttributes()) {
                                staxWriter.writeAttribute(attr.getKey(), attr.getValue());
                            }
                        }
                    } else {
                        staxWriter.writeStartElement(ext.getNamespace(), ext.getName(), "http://www.w3.org/1999/xhtml");
                    }
                    if (CollectionUtils.isNotEmpty(ext.getExtensibleTypes())) {
                        this.serialize(ext.getExtensibleTypes(), generator, provider);
                    }
                    if (ext.getValue() != null) {
                        staxWriter.writeCharacters(ext.getValue());
                    }
                    staxWriter.writeEndElement();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

