/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.i18n;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleRepository;
import org.sonar.api.utils.SonarException;
import org.sonar.test.TestUtils;

public final class RuleRepositoryTestHelper {
    private RuleRepositoryTestHelper() {
    }

    public static List<Rule> createRulesWithNameAndDescription(String pluginKey, RuleRepository repository) {
        Properties props = RuleRepositoryTestHelper.loadProperties(String.format("/org/sonar/l10n/%s.properties", pluginKey));
        List rules = repository.createRules();
        for (Rule rule : rules) {
            String name = props.getProperty(String.format("rule.%s.%s.name", repository.getKey(), rule.getKey()));
            String description = TestUtils.getResourceContent(String.format("/org/sonar/l10n/%s/rules/%s/%s.html", pluginKey, repository.getKey(), rule.getKey()));
            rule.setName(name);
            rule.setDescription(description);
        }
        return rules;
    }

    private static Properties loadProperties(String resourcePath) {
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = TestUtils.class.getResourceAsStream(resourcePath);
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new SonarException("Unable to read properties " + resourcePath, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)input);
        }
    }
}

