/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import com.google.common.annotations.Beta;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.text.Line;
import org.sonar.squid.text.LinesFactory;
import org.sonar.squid.text.StringArrayReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source {
    private List<Line> lines = new ArrayList<Line>();
    private CodeRecognizer codeRecognizer;
    private Set<Integer> noSonarTagLines = new HashSet<Integer>();

    public Source(Reader reader, CodeRecognizer codeRecognizer, String ... additionalSingleLineCommentFlag) {
        this.codeRecognizer = codeRecognizer;
        LinesFactory linesFactory = new LinesFactory(reader, additionalSingleLineCommentFlag);
        this.lines = linesFactory.getLines();
        this.processLines();
    }

    public Source(String[] stringLines, CodeRecognizer codeRecognizer) {
        this(new StringArrayReader(stringLines), codeRecognizer, new String[0]);
    }

    private void processLines() {
        for (Line line : this.lines) {
            this.computeBlankLine(line);
            this.computeHeaderCommentLine(line);
            this.computeCommentLine(line);
            this.computeCommentBlankLine(line);
            this.computeLineOfCode(line);
            this.computeNoSonarTag(line);
            line.deleteLineContent();
        }
    }

    private void computeNoSonarTag(Line line) {
        if (line.isThereNoSonarTag()) {
            this.noSonarTagLines.add(line.getLineIndex());
        }
    }

    private void computeLineOfCode(Line line) {
        if (line.isThereCode()) {
            line.setMeasure(Metric.LINES_OF_CODE, 1);
        }
    }

    private void computeHeaderCommentLine(Line line) {
        if (line.isThereComment() && !line.isThereBlankComment() && line.isThereLicenseHeaderComment()) {
            line.setMeasure(Metric.HEADER_COMMENT_LINES, 1);
        }
    }

    private void computeCommentLine(Line line) {
        if (line.isThereComment() && !line.isThereBlankComment()) {
            if (line.isThereJavadoc() || line.isThereLicenseHeaderComment()) {
                line.setMeasure(Metric.COMMENT_LINES, 1);
                return;
            }
            boolean isCommentedOutCode = this.codeRecognizer.isLineOfCode(line.getComment());
            if (!isCommentedOutCode) {
                line.setMeasure(Metric.COMMENT_LINES, 1);
            } else {
                line.setMeasure(Metric.COMMENTED_OUT_CODE_LINES, 1);
            }
        }
    }

    private void computeBlankLine(Line line) {
        if (line.isBlank()) {
            line.setMeasure(Metric.BLANK_LINES, 1);
        }
    }

    private void computeCommentBlankLine(Line line) {
        if (line.isThereBlankComment()) {
            line.setMeasure(Metric.COMMENT_BLANK_LINES, 1);
        }
    }

    public int getMeasure(Metric metric) {
        return this.getMeasure(metric, 1, this.lines.size());
    }

    public int getMeasure(Metric metric, int fromLine, int toLine) {
        if (toLine > this.lines.size()) {
            throw new IllegalStateException("There are only " + this.lines.size() + " lines in the file and you're trying to reach line " + toLine);
        }
        if (fromLine < 1) {
            throw new IllegalStateException("Line index starts from 1 and not from " + fromLine);
        }
        int measure = 0;
        for (int index = fromLine; index < toLine + 1; ++index) {
            measure += this.lines.get(index - 1).getInt(metric);
        }
        return measure;
    }

    public Set<Integer> getNoSonarTagLines() {
        return this.noSonarTagLines;
    }

    @Beta
    public int getNumberOfLines() {
        return this.lines.size();
    }
}

