/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.measures;

import java.util.IdentityHashMap;
import java.util.Map;
import org.sonar.squid.measures.MetricDef;

public class Measures {
    private Map<MetricDef, Measure> measures = new IdentityHashMap<MetricDef, Measure>();

    public double getValue(MetricDef metric) {
        Measure measure = this.measures.get(metric);
        if (measure == null) {
            return 0.0;
        }
        return measure.getValue();
    }

    public Object getData(MetricDef metric) {
        Measure measure = this.measures.get(metric);
        if (measure == null) {
            return null;
        }
        return measure.getData();
    }

    public void setValue(MetricDef metric, double measure) {
        this.getMeasureOrCreateIt(metric).setValue(measure);
    }

    public void setData(MetricDef metric, Object data) {
        this.getMeasureOrCreateIt(metric).setData(data);
    }

    private Measure getMeasureOrCreateIt(MetricDef metric) {
        Measure measure = this.measures.get(metric);
        if (measure == null) {
            measure = new Measure(0.0);
            this.measures.put(metric, measure);
        }
        return measure;
    }

    public void removeMeasure(MetricDef metric) {
        this.measures.remove(metric);
    }

    private static final class Measure {
        private double value;
        private Object data;

        private Measure(double value) {
            this.value = value;
        }

        private double getValue() {
            return this.value;
        }

        private void setValue(double value) {
            this.value = value;
        }

        private Object getData() {
            return this.data;
        }

        private void setData(Object data) {
            this.data = data;
        }
    }
}

