/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.recognizer;

import java.util.ArrayList;
import java.util.List;
import org.sonar.squid.recognizer.Detector;
import org.sonar.squid.recognizer.LanguageFootprint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeRecognizer {
    private LanguageFootprint language;
    private double threshold;

    public CodeRecognizer(double threshold, LanguageFootprint language) {
        this.language = language;
        this.threshold = threshold;
    }

    public final double recognition(String line) {
        double probability = 0.0;
        for (Detector pattern : this.language.getDetectors()) {
            probability = 1.0 - (1.0 - probability) * (1.0 - pattern.recognition(line));
        }
        return probability;
    }

    public final List<String> extractCodeLines(List<String> lines) {
        ArrayList<String> codeLines = new ArrayList<String>();
        for (String line : lines) {
            if (!(this.recognition(line) >= this.threshold)) continue;
            codeLines.add(line);
        }
        return codeLines;
    }

    public final boolean isLineOfCode(String line) {
        return this.recognition(line) - this.threshold > 0.0;
    }
}

