/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.scan.filesystem.FileType;

class WhiteListFileFilter
implements FileSystemFilter {
    private final FileType fileType;
    private final Set<File> files;

    WhiteListFileFilter(FileType fileType, Set<File> files) {
        Preconditions.checkNotNull((Object)fileType);
        Preconditions.checkNotNull(files);
        this.fileType = fileType;
        this.files = files;
    }

    public boolean accept(File file, FileSystemFilter.Context context) {
        return !context.type().equals((Object)this.fileType) || this.files.contains(file);
    }

    public String toString() {
        return StringUtils.capitalize((String)this.fileType.name().toLowerCase()) + " files: " + SystemUtils.LINE_SEPARATOR + Joiner.on((String)SystemUtils.LINE_SEPARATOR).join(this.files);
    }
}

