/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.SonarException;

public class ProjectReactorValidator {
    private static final String VALID_MODULE_KEY_REGEXP = "[0-9a-zA-Z\\-_\\.:]+";
    private final Settings settings;

    public ProjectReactorValidator(Settings settings) {
        this.settings = settings;
    }

    public void validate(ProjectReactor reactor) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            this.validateModule(moduleDef, validationMessages);
        }
        this.validateBranch(validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new SonarException("Validation of project reactor failed:\n  o " + Joiner.on((String)"\n  o ").join(validationMessages));
        }
    }

    private void validateModule(ProjectDefinition moduleDef, List<String> validationMessages) {
        this.validateKey(moduleDef, validationMessages);
    }

    private void validateKey(ProjectDefinition def, List<String> validationMessages) {
        if (!def.getKey().matches(VALID_MODULE_KEY_REGEXP)) {
            validationMessages.add(String.format("%s is not a valid project or module key", def.getKey()));
        }
    }

    private void validateBranch(List<String> validationMessages) {
        String branch = this.settings.getString("sonar.branch");
        if (StringUtils.isNotEmpty((String)branch) && !branch.matches(VALID_MODULE_KEY_REGEXP)) {
            validationMessages.add(String.format("%s is not a valid branch name", branch));
        }
    }
}

