/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.platform.Server;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.issue.IssueCache;
import org.sonar.core.i18n.RuleI18nManager;

public class JsonReport
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReport.class);
    private final Settings settings;
    private final ModuleFileSystem fileSystem;
    private final Server server;
    private final RuleI18nManager ruleI18nManager;
    private final IssueCache issueCache;

    public JsonReport(Settings settings, ModuleFileSystem fileSystem, Server server, RuleI18nManager ruleI18nManager, IssueCache issueCache) {
        this.settings = settings;
        this.fileSystem = fileSystem;
        this.server = server;
        this.ruleI18nManager = ruleI18nManager;
        this.issueCache = issueCache;
    }

    public void execute() {
        if (this.settings.getBoolean("sonar.dryRun")) {
            this.exportResults();
        }
    }

    private void exportResults() {
        File exportFile = new File(this.fileSystem.workingDir(), this.settings.getString("sonar.report.export.path"));
        LOG.info("Export results to " + exportFile.getAbsolutePath());
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(exportFile));
            this.writeJson(output);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Unable to write report results in file " + exportFile.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }

    @VisibleForTesting
    void writeJson(Writer writer) {
        JsonWriter json = null;
        try {
            json = new JsonWriter(writer);
            json.setSerializeNulls(false);
            json.beginObject();
            json.name("version").value(this.server.getVersion());
            HashSet ruleKeys = Sets.newHashSet();
            HashSet componentKeys = Sets.newHashSet();
            this.writeJsonIssues(json, ruleKeys, componentKeys);
            this.writeJsonComponents(json, componentKeys);
            this.writeJsonRules(json, ruleKeys);
            json.endObject().flush();
        }
        catch (IOException e) {
            try {
                throw new SonarException("Unable to write JSON report", (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(json);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)json);
    }

    private void writeJsonIssues(JsonWriter json, Set<RuleKey> ruleKeys, Set<String> componentKeys) throws IOException {
        json.name("issues").beginArray();
        for (DefaultIssue issue : this.getIssues()) {
            if (issue.resolution() != null) continue;
            json.beginObject().name("key").value(issue.key()).name("component").value(issue.componentKey()).name("line").value((Number)issue.line()).name("message").value(issue.message()).name("severity").value(issue.severity()).name("rule").value(issue.ruleKey().toString()).name("status").value(issue.status()).name("resolution").value(issue.resolution()).name("isNew").value(issue.isNew()).name("reporter").value(issue.reporter()).name("assignee").value(issue.assignee()).name("effortToFix").value((Number)issue.effortToFix());
            if (issue.creationDate() != null) {
                json.name("creationDate").value(DateUtils.formatDateTime((Date)issue.creationDate()));
            }
            if (issue.updateDate() != null) {
                json.name("updateDate").value(DateUtils.formatDateTime((Date)issue.updateDate()));
            }
            if (issue.closeDate() != null) {
                json.name("closeDate").value(DateUtils.formatDateTime((Date)issue.closeDate()));
            }
            json.endObject();
            componentKeys.add(issue.componentKey());
            ruleKeys.add(issue.ruleKey());
        }
        json.endArray();
    }

    private void writeJsonComponents(JsonWriter json, Set<String> componentKeys) throws IOException {
        json.name("components").beginArray();
        for (String componentKey : componentKeys) {
            json.beginObject().name("key").value(componentKey).endObject();
        }
        json.endArray();
    }

    private void writeJsonRules(JsonWriter json, Set<RuleKey> ruleKeys) throws IOException {
        json.name("rules").beginArray();
        for (RuleKey ruleKey : ruleKeys) {
            json.beginObject().name("key").value(ruleKey.toString()).name("rule").value(ruleKey.rule()).name("repository").value(ruleKey.repository()).name("name").value(this.getRuleName(ruleKey)).endObject();
        }
        json.endArray();
    }

    private String getRuleName(RuleKey ruleKey) {
        return this.ruleI18nManager.getName(ruleKey.repository(), ruleKey.rule(), Locale.getDefault());
    }

    @VisibleForTesting
    Iterable<DefaultIssue> getIssues() {
        return this.issueCache.all();
    }
}

