/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.profiling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.events.DecoratorExecutionHandler;
import org.sonar.api.batch.events.DecoratorsPhaseHandler;
import org.sonar.api.batch.events.PostJobExecutionHandler;
import org.sonar.api.batch.events.PostJobsPhaseHandler;
import org.sonar.api.batch.events.ProjectAnalysisHandler;
import org.sonar.api.batch.events.SensorExecutionHandler;
import org.sonar.api.batch.events.SensorsPhaseHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeUtils;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.profiling.AbstractTimeProfiling;
import org.sonar.batch.profiling.Clock;
import org.sonar.batch.profiling.ModuleProfiling;
import org.sonar.batch.profiling.PhaseProfiling;

public class PhasesSumUpTimeProfiler
implements ProjectAnalysisHandler,
SensorExecutionHandler,
DecoratorExecutionHandler,
PostJobExecutionHandler,
DecoratorsPhaseHandler,
SensorsPhaseHandler,
PostJobsPhaseHandler {
    static Logger LOG = LoggerFactory.getLogger(PhasesSumUpTimeProfiler.class);
    @VisibleForTesting
    ModuleProfiling currentModuleProfiling;
    @VisibleForTesting
    ModuleProfiling totalProfiling;
    private List<ModuleProfiling> modulesProfilings = new ArrayList<ModuleProfiling>();
    private DecoratorsProfiler decoratorsProfiler;
    private Clock clock;

    public PhasesSumUpTimeProfiler() {
        this(new Clock());
    }

    static void println(String msg) {
        LOG.info(msg);
    }

    @VisibleForTesting
    PhasesSumUpTimeProfiler(Clock clock) {
        this.clock = clock;
        this.totalProfiling = new ModuleProfiling(null, clock);
    }

    public void onProjectAnalysis(ProjectAnalysisHandler.ProjectAnalysisEvent event) {
        Project module = event.getProject();
        if (event.isStart()) {
            this.decoratorsProfiler = new DecoratorsProfiler();
            this.currentModuleProfiling = new ModuleProfiling(module, this.clock);
        } else {
            this.currentModuleProfiling.stop();
            this.modulesProfilings.add(this.currentModuleProfiling);
            long moduleTotalTime = this.currentModuleProfiling.totalTime();
            PhasesSumUpTimeProfiler.println("\n -------- Profiling of module " + module.getName() + ": " + TimeUtils.formatDuration((long)moduleTotalTime) + " --------\n");
            this.currentModuleProfiling.dump();
            PhasesSumUpTimeProfiler.println("\n -------- End of profiling of module " + module.getName() + " --------\n");
            this.totalProfiling.merge(this.currentModuleProfiling);
            if (module.isRoot() && !module.getModules().isEmpty()) {
                this.dumpTotalExecutionSummary();
            }
        }
    }

    private void dumpTotalExecutionSummary() {
        this.totalProfiling.stop();
        long totalTime = this.totalProfiling.totalTime();
        PhasesSumUpTimeProfiler.println("\n ======== Profiling of total execution: " + TimeUtils.formatDuration((long)totalTime) + " ========\n");
        PhasesSumUpTimeProfiler.println(" * Module execution time breakdown: ");
        double percent = (double)totalTime / 100.0;
        for (ModuleProfiling modulesProfiling : AbstractTimeProfiling.truncate(AbstractTimeProfiling.sortByDescendingTotalTime(this.modulesProfilings))) {
            StringBuilder sb = new StringBuilder();
            sb.append("   o ").append(modulesProfiling.moduleName()).append(" execution time: ").append(modulesProfiling.totalTimeAsString()).append(" (").append((int)((double)modulesProfiling.totalTime() / percent)).append("%)");
            PhasesSumUpTimeProfiler.println(sb.toString());
        }
        PhasesSumUpTimeProfiler.println("");
        this.totalProfiling.dump();
        PhasesSumUpTimeProfiler.println("\n ======== End of profiling of total execution ========\n");
    }

    public void onSensorsPhase(SensorsPhaseHandler.SensorsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.SENSOR);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.SENSOR).stop();
        }
    }

    public void onSensorExecution(SensorExecutionHandler.SensorExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.SENSOR);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getSensor());
        } else {
            profiling.getProfilingPerItem(event.getSensor()).stop();
        }
    }

    public void onDecoratorExecution(DecoratorExecutionHandler.DecoratorExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.DECORATOR);
        if (event.isStart()) {
            if (profiling.getProfilingPerItem(event.getDecorator()) == null) {
                profiling.newItemProfiling(event.getDecorator());
            }
            this.decoratorsProfiler.start(event.getDecorator());
        } else {
            this.decoratorsProfiler.stop();
        }
    }

    public void onDecoratorsPhase(DecoratorsPhaseHandler.DecoratorsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.DECORATOR);
        } else {
            for (Decorator decorator : this.decoratorsProfiler.getDurations().keySet()) {
                this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.DECORATOR).getProfilingPerItem(decorator).setTotalTime(this.decoratorsProfiler.getDurations().get(decorator));
            }
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.DECORATOR).stop();
        }
    }

    public void onPostJobsPhase(PostJobsPhaseHandler.PostJobsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.POSTJOB);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.POSTJOB).stop();
        }
    }

    public void onPostJobExecution(PostJobExecutionHandler.PostJobExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.POSTJOB);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getPostJob());
        } else {
            profiling.getProfilingPerItem(event.getPostJob()).stop();
        }
    }

    class DecoratorsProfiler {
        List<Decorator> decorators = Lists.newArrayList();
        Map<Decorator, Long> durations = new IdentityHashMap<Decorator, Long>();
        long startTime;
        Decorator currentDecorator;

        DecoratorsProfiler() {
        }

        void start(Decorator decorator) {
            this.startTime = PhasesSumUpTimeProfiler.this.clock.now();
            this.currentDecorator = decorator;
        }

        void stop() {
            Long cumulatedDuration;
            if (this.durations.containsKey(this.currentDecorator)) {
                cumulatedDuration = this.durations.get(this.currentDecorator);
            } else {
                this.decorators.add(this.currentDecorator);
                cumulatedDuration = 0L;
            }
            this.durations.put(this.currentDecorator, cumulatedDuration + (PhasesSumUpTimeProfiler.this.clock.now() - this.startTime));
        }

        public Map<Decorator, Long> getDurations() {
            return this.durations;
        }
    }
}

