/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.profiling;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeUtils;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.profiling.AbstractTimeProfiling;
import org.sonar.batch.profiling.Clock;
import org.sonar.batch.profiling.PhaseProfiling;

public class ModuleProfiling
extends AbstractTimeProfiling {
    private Map<Phases.Phase, PhaseProfiling> profilingPerPhase = new HashMap<Phases.Phase, PhaseProfiling>();
    private Clock clock;
    private Project module;

    public ModuleProfiling(@CheckForNull Project module, Clock clock) {
        super(clock);
        this.module = module;
        this.clock = clock;
    }

    public String moduleName() {
        if (this.module != null) {
            return this.module.getName();
        }
        return null;
    }

    public PhaseProfiling getProfilingPerPhase(Phases.Phase phase) {
        return this.profilingPerPhase.get((Object)phase);
    }

    public void addPhaseProfiling(Phases.Phase phase) {
        this.profilingPerPhase.put(phase, PhaseProfiling.create(this.clock, phase));
    }

    public void dump() {
        double percent = (double)this.totalTime() / 100.0;
        for (PhaseProfiling phaseProfiling : ModuleProfiling.sortByDescendingTotalTime(this.profilingPerPhase.values())) {
            StringBuilder sb = new StringBuilder();
            sb.append(" * ").append((Object)phaseProfiling.phase()).append(" execution time: ").append(phaseProfiling.totalTimeAsString()).append(" (").append((int)((double)phaseProfiling.totalTime() / percent)).append("%)");
            this.println(sb.toString());
        }
        for (Phases.Phase phase : Phases.Phase.values()) {
            if (!this.profilingPerPhase.containsKey((Object)phase)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("\n * ").append((Object)phase).append(" execution time breakdown: ").append(TimeUtils.formatDuration((long)this.getProfilingPerPhase(phase).totalTime()));
            this.println(sb.toString());
            this.getProfilingPerPhase(phase).dump();
        }
    }

    public void merge(ModuleProfiling other) {
        super.add(other);
        for (Map.Entry<Phases.Phase, PhaseProfiling> entry : other.profilingPerPhase.entrySet()) {
            if (!this.profilingPerPhase.containsKey((Object)entry.getKey())) {
                this.addPhaseProfiling(entry.getKey());
            }
            this.getProfilingPerPhase(entry.getKey()).merge(entry.getValue());
        }
    }
}

