/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.phases.PostJobExecutionEvent;
import org.sonar.batch.phases.PostJobPhaseEvent;
import org.sonar.batch.scan.DeprecatedJsonReport;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.maven.MavenPluginExecutor;

public class PostJobsExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PostJobsExecutor.class);
    private final BatchExtensionDictionnary selector;
    private final Project project;
    private final DefaultModuleFileSystem fs;
    private final MavenPluginExecutor mavenExecutor;
    private final DeprecatedJsonReport localModeExporter;
    private final EventBus eventBus;

    public PostJobsExecutor(BatchExtensionDictionnary selector, Project project, DefaultModuleFileSystem fs, MavenPluginExecutor mavenExecutor, DeprecatedJsonReport localModeExporter, EventBus eventBus) {
        this.selector = selector;
        this.project = project;
        this.fs = fs;
        this.mavenExecutor = mavenExecutor;
        this.localModeExporter = localModeExporter;
        this.eventBus = eventBus;
    }

    public void execute(SensorContext context) {
        Collection postJobs = this.selector.select(PostJob.class, this.project, true);
        this.eventBus.fireEvent(new PostJobPhaseEvent(Lists.newArrayList((Iterable)postJobs), true));
        this.execute(context, postJobs);
        this.exportLocalModeResults();
        this.eventBus.fireEvent(new PostJobPhaseEvent(Lists.newArrayList((Iterable)postJobs), false));
    }

    private void execute(SensorContext context, Collection<PostJob> postJobs) {
        this.logPostJobs(postJobs);
        for (PostJob postJob : postJobs) {
            LOG.info("Executing post-job {}", postJob.getClass());
            this.eventBus.fireEvent(new PostJobExecutionEvent(postJob, true));
            this.executeMavenPlugin(postJob);
            postJob.executeOn(this.project, context);
            this.eventBus.fireEvent(new PostJobExecutionEvent(postJob, false));
        }
    }

    private void logPostJobs(Collection<PostJob> postJobs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Post-jobs : {}", (Object)StringUtils.join(postJobs, (String)" -> "));
        }
    }

    private void executeMavenPlugin(PostJob job) {
        MavenPluginHandler handler;
        if (job instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)job).getMavenPluginHandler(this.project)) != null) {
            this.mavenExecutor.execute(this.project, this.fs, handler);
        }
    }

    private void exportLocalModeResults() {
        this.localModeExporter.execute();
    }
}

