/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import javax.annotation.Nullable;
import org.sonar.api.BatchComponent;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.batch.issue.IssueCache;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.core.issue.DefaultIssueBuilder;

public class ScanIssues
implements BatchComponent {
    private final RulesProfile qProfile;
    private final IssueCache cache;
    private final Project project;
    private final IssueFilters filters;

    public ScanIssues(RulesProfile qProfile, IssueCache cache, Project project, IssueFilters filters) {
        this.qProfile = qProfile;
        this.cache = cache;
        this.project = project;
        this.filters = filters;
    }

    public boolean initAndAddIssue(DefaultIssue issue) {
        return this.initAndAddIssue(issue, null);
    }

    public boolean initAndAddViolation(Violation violation) {
        DefaultIssue issue = this.newIssue(violation);
        return this.initAndAddIssue(issue, violation);
    }

    private DefaultIssue newIssue(Violation violation) {
        return (DefaultIssue)new DefaultIssueBuilder().componentKey(violation.getResource().getEffectiveKey()).ruleKey(RuleKey.of((String)violation.getRule().getRepositoryKey(), (String)violation.getRule().getKey())).effortToFix(violation.getCost()).line(violation.getLineId()).message(violation.getMessage()).severity(violation.getSeverity() != null ? violation.getSeverity().name() : null).build();
    }

    private boolean initAndAddIssue(DefaultIssue issue, @Nullable Violation violation) {
        ActiveRule activeRule = this.qProfile.getActiveRule(issue.ruleKey().repository(), issue.ruleKey().rule());
        if (activeRule == null || activeRule.getRule() == null) {
            return false;
        }
        issue.setCreationDate(this.project.getAnalysisDate());
        issue.setUpdateDate(this.project.getAnalysisDate());
        if (issue.severity() == null) {
            issue.setSeverity(activeRule.getSeverity().name());
        }
        if (this.filters.accept(issue, violation)) {
            this.cache.put(issue);
            return true;
        }
        return false;
    }
}

