/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.IssueFilter;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.rules.Violation;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.issue.DeprecatedViolations;

public class IssueFilters
implements BatchExtension {
    private final ViolationFilters deprecatedFilters;
    private final DeprecatedViolations deprecatedViolations;
    private final IssueFilter[] filters;

    public IssueFilters(ViolationFilters deprecatedFilters, DeprecatedViolations deprecatedViolations, IssueFilter[] filters) {
        this.deprecatedFilters = deprecatedFilters;
        this.deprecatedViolations = deprecatedViolations;
        this.filters = filters;
    }

    public IssueFilters(ViolationFilters deprecatedFilters, DeprecatedViolations deprecatedViolations) {
        this(deprecatedFilters, deprecatedViolations, new IssueFilter[0]);
    }

    public boolean accept(DefaultIssue issue, @Nullable Violation violation) {
        for (IssueFilter filter : this.filters) {
            if (filter.accept((Issue)issue)) continue;
            return false;
        }
        if (!this.deprecatedFilters.isEmpty()) {
            Violation v = violation != null ? violation : this.deprecatedViolations.toViolation(issue);
            return !this.deprecatedFilters.isIgnored(v);
        }
        return true;
    }
}

