/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Sets;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.exception.PersistitException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Cache<K, V extends Serializable> {
    private static final String DEFAULT_GROUP = "_";
    private final String name;
    private final Exchange exchange;

    Cache(String name, Exchange exchange) {
        this.name = name;
        this.exchange = exchange;
    }

    public Cache put(K key, V value) {
        return this.put(DEFAULT_GROUP, key, value);
    }

    public Cache put(String group, K key, V value) {
        try {
            this.exchange.clear();
            this.exchange.append((Object)group).append(key);
            this.exchange.getValue().put(value);
            this.exchange.store();
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to put element in the cache " + this.name, e);
        }
    }

    public V get(String group, K key) {
        try {
            this.exchange.clear();
            this.exchange.append((Object)group).append(key);
            this.exchange.fetch();
            if (!this.exchange.getValue().isDefined()) {
                return null;
            }
            return (V)((Serializable)this.exchange.getValue().get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get element from cache " + this.name, e);
        }
    }

    public V get(K key) {
        return this.get(DEFAULT_GROUP, key);
    }

    public boolean remove(String group, K key) {
        try {
            this.exchange.clear();
            this.exchange.append((Object)group).append(key);
            return this.exchange.remove();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get element from cache " + this.name, e);
        }
    }

    public boolean remove(K key) {
        return this.remove(DEFAULT_GROUP, key);
    }

    public Cache clear(String group) {
        try {
            this.exchange.clear();
            this.exchange.append((Object)group);
            Key key = new Key(this.exchange.getKey());
            key.append((Object)Key.AFTER);
            this.exchange.removeKeyRange(this.exchange.getKey(), key);
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to clear group '" + group + "' from cache " + this.name, e);
        }
    }

    public Cache clear() {
        return this.clear(DEFAULT_GROUP);
    }

    public void clearAll() {
        try {
            this.exchange.clear();
            this.exchange.removeAll();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to clear cache", e);
        }
    }

    public Set<K> keySet(String group) {
        try {
            LinkedHashSet keys = Sets.newLinkedHashSet();
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append((Object)group);
            iteratorExchange.append((Object)Key.BEFORE);
            while (iteratorExchange.next(false)) {
                keys.add(iteratorExchange.getKey().indexTo(-1).decode());
            }
            return keys;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get keys from cache " + this.name, e);
        }
    }

    public Set<K> keySet() {
        return this.keySet(DEFAULT_GROUP);
    }

    public Iterable<V> values(String group) {
        try {
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append((Object)group).append((Object)Key.BEFORE);
            return new ValueIterable(iteratorExchange, false);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get values from cache " + this.name, e);
        }
    }

    public Iterable<V> values() {
        return this.values(DEFAULT_GROUP);
    }

    public Iterable<V> allValues() {
        try {
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append((Object)Key.BEFORE);
            return new ValueIterable(iteratorExchange, true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get values from cache " + this.name, e);
        }
    }

    public Set<String> groups() {
        try {
            LinkedHashSet groups = Sets.newLinkedHashSet();
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append((Object)Key.BEFORE);
            while (iteratorExchange.next(false)) {
                groups.add(iteratorExchange.getKey().decodeString());
            }
            return groups;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get values from cache " + this.name, e);
        }
    }

    public <T extends Serializable> Iterable<Entry<T>> entries() {
        this.exchange.clear().to((Object)Key.BEFORE);
        return new EntryIterable(new Exchange(this.exchange), true);
    }

    public <T extends Serializable> Iterable<Entry<T>> entries(String group) {
        this.exchange.clear().append((Object)group).append((Object)Key.BEFORE);
        return new EntryIterable(new Exchange(this.exchange), false);
    }

    public static class Entry<T extends Serializable> {
        private final String group;
        private final String key;
        private final T value;

        Entry(String group, String key, T value) {
            this.group = group;
            this.key = key;
            this.value = value;
        }

        public String group() {
            return this.group;
        }

        public String key() {
            return this.key;
        }

        @CheckForNull
        public T value() {
            return this.value;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class EntryIterator<T extends Serializable>
    implements Iterator<Entry<T>> {
        private final Exchange exchange;
        private final boolean deep;

        private EntryIterator(Exchange exchange, boolean deep) {
            this.exchange = exchange;
            this.deep = deep;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.exchange.next(this.deep);
            }
            catch (PersistitException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Entry next() {
            Serializable value = null;
            if (this.exchange.getValue().isDefined()) {
                value = (Serializable)this.exchange.getValue().get();
            }
            Key key = this.exchange.getKey();
            return new Entry<Serializable>(key.indexTo(-2).decodeString(), key.indexTo(-1).decodeString(), value);
        }

        @Override
        public void remove() {
        }
    }

    private static class EntryIterable<T extends Serializable>
    implements Iterable<Entry<T>> {
        private final EntryIterator<T> it;

        private EntryIterable(Exchange exchange, boolean deep) {
            this.it = new EntryIterator(exchange, deep);
        }

        @Override
        public Iterator<Entry<T>> iterator() {
            return this.it;
        }
    }

    private static class ValueIterator<T extends Serializable>
    implements Iterator<T> {
        private final Exchange exchange;
        private final boolean deep;

        private ValueIterator(Exchange exchange, boolean deep) {
            this.exchange = exchange;
            this.deep = deep;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.exchange.next(this.deep);
            }
            catch (PersistitException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public T next() {
            Serializable value = null;
            if (this.exchange.getValue().isDefined()) {
                value = (Serializable)this.exchange.getValue().get();
            }
            return (T)value;
        }

        @Override
        public void remove() {
        }
    }

    private static class ValueIterable<T extends Serializable>
    implements Iterable<T> {
        private final Iterator<T> iterator;

        private ValueIterable(Exchange exchange, boolean deep) {
            this.iterator = new ValueIterator(exchange, deep);
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

