/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.config.Settings;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinder;

public class TimeMachineConfiguration
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(TimeMachineConfiguration.class);
    private static final int NUMBER_OF_VARIATION_SNAPSHOTS = 5;
    private static final int CORE_TENDENCY_DEPTH_DEFAULT_VALUE = 30;
    private Project project;
    private final Settings settings;
    private List<PastSnapshot> projectPastSnapshots;
    private DatabaseSession session;

    public TimeMachineConfiguration(DatabaseSession session, Project project, Settings settings, PastSnapshotFinder pastSnapshotFinder) {
        this.session = session;
        this.project = project;
        this.settings = settings;
        this.initPastSnapshots(pastSnapshotFinder, this.getRootProject(project).getQualifier());
    }

    private Project getRootProject(Project project) {
        if (!project.isRoot()) {
            return this.getRootProject(project.getRoot());
        }
        return project;
    }

    private void initPastSnapshots(PastSnapshotFinder pastSnapshotFinder, String rootQualifier) {
        Snapshot projectSnapshot = this.buildProjectSnapshot();
        this.projectPastSnapshots = Lists.newLinkedList();
        if (projectSnapshot != null) {
            for (int index = 1; index <= 5; ++index) {
                PastSnapshot pastSnapshot = pastSnapshotFinder.find(projectSnapshot, rootQualifier, this.settings, index);
                if (pastSnapshot == null) continue;
                this.log(pastSnapshot);
                this.projectPastSnapshots.add(pastSnapshot);
            }
        }
    }

    private Snapshot buildProjectSnapshot() {
        Query query = this.session.createNativeQuery("select p.id from projects p where p.kee=:resourceKey and p.qualifier<>:lib and p.enabled=:enabled");
        query.setParameter("resourceKey", (Object)this.project.getKey());
        query.setParameter("lib", (Object)"LIB");
        query.setParameter("enabled", (Object)Boolean.TRUE);
        Snapshot snapshot = null;
        Number projectId = (Number)this.session.getSingleResult(query, null);
        if (projectId != null) {
            snapshot = new Snapshot();
            snapshot.setResourceId(Integer.valueOf(projectId.intValue()));
            snapshot.setCreatedAt(this.project.getAnalysisDate());
            snapshot.setBuildDate(new Date());
            snapshot.setVersion(this.project.getAnalysisVersion());
        }
        return snapshot;
    }

    private void log(PastSnapshot pastSnapshot) {
        String qualifier = pastSnapshot.getQualifier();
        if (StringUtils.equals((String)"VW", (String)qualifier) || StringUtils.equals((String)"SVW", (String)qualifier)) {
            LOG.debug(pastSnapshot.toString());
        } else {
            LOG.info(pastSnapshot.toString());
        }
    }

    public int getTendencyPeriodInDays() {
        return 30;
    }

    public List<PastSnapshot> getProjectPastSnapshots() {
        return this.projectPastSnapshots;
    }
}

