/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.config.Settings;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByPreviousVersion;
import org.sonar.batch.components.PastSnapshotFinderByVersion;

public class PastSnapshotFinder
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(PastSnapshotFinder.class);
    private PastSnapshotFinderByDays finderByDays;
    private PastSnapshotFinderByVersion finderByVersion;
    private PastSnapshotFinderByDate finderByDate;
    private PastSnapshotFinderByPreviousAnalysis finderByPreviousAnalysis;
    private PastSnapshotFinderByPreviousVersion finderByPreviousVersion;

    public PastSnapshotFinder(PastSnapshotFinderByDays finderByDays, PastSnapshotFinderByVersion finderByVersion, PastSnapshotFinderByDate finderByDate, PastSnapshotFinderByPreviousAnalysis finderByPreviousAnalysis, PastSnapshotFinderByPreviousVersion finderByPreviousVersion) {
        this.finderByDays = finderByDays;
        this.finderByVersion = finderByVersion;
        this.finderByDate = finderByDate;
        this.finderByPreviousAnalysis = finderByPreviousAnalysis;
        this.finderByPreviousVersion = finderByPreviousVersion;
    }

    @Deprecated
    public PastSnapshot find(Snapshot projectSnapshot, Configuration conf, int index) {
        String propertyValue = PastSnapshotFinder.getPropertyValue(conf, index);
        PastSnapshot pastSnapshot = this.find(projectSnapshot, index, propertyValue);
        if (pastSnapshot == null && StringUtils.isNotBlank((String)propertyValue)) {
            LoggerFactory.getLogger(PastSnapshotFinder.class).debug("Property sonar.timemachine.period" + index + " is not valid: " + propertyValue);
        }
        return pastSnapshot;
    }

    @Deprecated
    static String getPropertyValue(Configuration conf, int index) {
        String defaultValue = null;
        switch (index) {
            case 1: {
                defaultValue = "previous_analysis";
                break;
            }
            case 2: {
                defaultValue = "5";
                break;
            }
            case 3: {
                defaultValue = "30";
                break;
            }
            case 4: {
                defaultValue = "";
                break;
            }
            case 5: {
                defaultValue = "";
            }
        }
        return conf.getString("sonar.timemachine.period" + index, defaultValue);
    }

    public PastSnapshot find(Snapshot projectSnapshot, String rootQualifier, Settings settings, int index) {
        String propertyValue = PastSnapshotFinder.getPropertyValue(rootQualifier, settings, index);
        PastSnapshot pastSnapshot = this.find(projectSnapshot, index, propertyValue);
        if (pastSnapshot == null && StringUtils.isNotBlank((String)propertyValue)) {
            LOG.debug("Property sonar.timemachine.period" + index + " is not valid: " + propertyValue);
        }
        return pastSnapshot;
    }

    public PastSnapshot find(Snapshot projectSnapshot, Settings settings, int index) {
        return this.find(projectSnapshot, null, settings, index);
    }

    static String getPropertyValue(String rootQualifier, Settings settings, int index) {
        String value = settings.getString("sonar.timemachine.period" + index);
        if (index > 3 && Strings.isNullOrEmpty((String)value)) {
            value = settings.getString("sonar.timemachine.period" + index + "." + rootQualifier);
        }
        return value;
    }

    public PastSnapshot findPreviousAnalysis(Snapshot projectSnapshot) {
        return this.finderByPreviousAnalysis.findByPreviousAnalysis(projectSnapshot);
    }

    public PastSnapshot find(Snapshot projectSnapshot, int index, String property) {
        if (StringUtils.isBlank((String)property)) {
            return null;
        }
        PastSnapshot result = this.findByDays(projectSnapshot, property);
        if (result == null && (result = this.findByDate(projectSnapshot, property)) == null && (result = this.findByPreviousAnalysis(projectSnapshot, property)) == null && (result = this.findByPreviousVersion(projectSnapshot, property)) == null) {
            result = this.findByVersion(projectSnapshot, property);
        }
        if (result != null) {
            result.setIndex(index);
        }
        return result;
    }

    private PastSnapshot findByPreviousAnalysis(Snapshot projectSnapshot, String property) {
        PastSnapshot pastSnapshot = null;
        if (StringUtils.equals((String)"previous_analysis", (String)property)) {
            pastSnapshot = this.finderByPreviousAnalysis.findByPreviousAnalysis(projectSnapshot);
        }
        return pastSnapshot;
    }

    private PastSnapshot findByPreviousVersion(Snapshot projectSnapshot, String property) {
        PastSnapshot pastSnapshot = null;
        if (StringUtils.equals((String)"previous_version", (String)property)) {
            pastSnapshot = this.finderByPreviousVersion.findByPreviousVersion(projectSnapshot);
        }
        return pastSnapshot;
    }

    private PastSnapshot findByDate(Snapshot projectSnapshot, String property) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(property);
            return this.finderByDate.findByDate(projectSnapshot, date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private PastSnapshot findByVersion(Snapshot projectSnapshot, String property) {
        return this.finderByVersion.findByVersion(projectSnapshot, property);
    }

    private PastSnapshot findByDays(Snapshot projectSnapshot, String property) {
        try {
            int days = Integer.parseInt(property);
            return this.finderByDays.findFromDays(projectSnapshot, days);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

