/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.config.Settings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.task.TaskExtension;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.scan.ScanTask;
import org.sonar.batch.tasks.ListTask;
import org.sonar.batch.tasks.Tasks;
import org.sonar.core.resource.DefaultResourcePermissions;

public class TaskContainer
extends ComponentContainer {
    public TaskContainer(ComponentContainer parent) {
        super(parent);
    }

    protected void doBeforeStart() {
        this.installCoreTasks();
        this.installTaskExtensions();
        this.installComponentsUsingTaskExtensions();
    }

    private void installCoreTasks() {
        this.add(new Object[]{ScanTask.DEFINITION, ScanTask.class, ListTask.DEFINITION, ListTask.class});
    }

    private void installTaskExtensions() {
        ((ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class)).install(this, new ExtensionMatcher(){

            @Override
            public boolean accept(Object extension) {
                return ExtensionUtils.isType(extension, TaskExtension.class);
            }
        });
    }

    private void installComponentsUsingTaskExtensions() {
        this.add(new Object[]{ResourceTypes.class, DefaultResourcePermissions.class, Tasks.class});
    }

    public void doAfterStart() {
        String taskKey = ((Settings)this.getComponentByType(Settings.class)).getString("sonar.task");
        TaskDefinition def = ((Tasks)this.getComponentByType(Tasks.class)).definition(taskKey);
        if (def == null) {
            throw new SonarException("Task " + taskKey + " does not exist");
        }
        Task task = (Task)this.getComponentByType(def.taskClass());
        if (task == null) {
            throw new IllegalStateException("Task " + taskKey + " is badly defined");
        }
        task.execute();
    }
}

