/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.core.DryRunIncompatible;

public class ExtensionUtils {
    private ExtensionUtils() {
    }

    public static boolean isInstantiationStrategy(Object extension, String strategy) {
        InstantiationStrategy annotation = (InstantiationStrategy)AnnotationUtils.getAnnotation((Object)extension, InstantiationStrategy.class);
        if (annotation != null) {
            return strategy.equals(annotation.value());
        }
        return "PER_PROJECT".equals(strategy);
    }

    public static boolean isBatchExtension(Object extension) {
        return ExtensionUtils.isType(extension, BatchExtension.class);
    }

    public static boolean supportsEnvironment(Object extension, EnvironmentInformation environment) {
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getAnnotation((Object)extension, SupportedEnvironment.class);
        if (env == null) {
            return true;
        }
        for (String supported : env.value()) {
            if (!StringUtils.equalsIgnoreCase((String)environment.getKey(), (String)supported)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsDryRun(Object extension) {
        return AnnotationUtils.getAnnotation((Object)extension, DryRunIncompatible.class) == null;
    }

    public static boolean isMavenExtensionOnly(Object extension) {
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getAnnotation((Object)extension, SupportedEnvironment.class);
        return env != null && env.value().length == 1 && StringUtils.equalsIgnoreCase((String)"maven", (String)env.value()[0]);
    }

    public static boolean isType(Object extension, Class<?> extensionClass) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        return extensionClass.isAssignableFrom(clazz);
    }
}

