/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public class ExtensionInstaller {
    private final BatchPluginRepository pluginRepository;
    private final EnvironmentInformation env;
    private final Settings settings;

    public ExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation env, Settings settings) {
        this.pluginRepository = pluginRepository;
        this.env = env;
        this.settings = settings;
    }

    public ExtensionInstaller install(ComponentContainer container, ExtensionMatcher matcher) {
        boolean dryRun = this.isDryRun();
        for (Map.Entry<PluginMetadata, Plugin> entry : this.pluginRepository.getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            for (Object extension : plugin.getExtensions()) {
                this.doInstall(container, matcher, metadata, dryRun, extension);
            }
        }
        List providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object object = provider.provide();
            if (object instanceof Iterable) {
                for (Object extension : (Iterable)object) {
                    this.doInstall(container, matcher, null, dryRun, extension);
                }
                continue;
            }
            this.doInstall(container, matcher, null, dryRun, object);
        }
        return this;
    }

    private void doInstall(ComponentContainer container, ExtensionMatcher matcher, @Nullable PluginMetadata metadata, boolean dryRun, Object extension) {
        if (ExtensionUtils.supportsEnvironment(extension, this.env) && (!dryRun || ExtensionUtils.supportsDryRun(extension)) && matcher.accept(extension)) {
            container.addExtension(metadata, extension);
        } else {
            container.declareExtension(metadata, extension);
        }
    }

    private boolean isDryRun() {
        return this.settings.getBoolean("sonar.dryRun");
    }
}

