/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.BootstrapProperties;

public class BootstrapSettings {
    private Map<String, String> properties = Maps.newHashMap();

    public BootstrapSettings(BootstrapProperties bootstrapProperties) {
        this(bootstrapProperties, null);
    }

    public BootstrapSettings(BootstrapProperties bootstrapProperties, @Nullable ProjectReactor projectReactor) {
        this.properties.putAll(bootstrapProperties.properties());
        if (projectReactor != null) {
            this.addProperties(projectReactor.getRoot().getProperties());
        }
        this.properties.putAll(System.getenv());
        this.addProperties(System.getProperties());
    }

    private void addProperties(Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (entry.getValue() == null) continue;
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String key) {
        return this.properties.get(key);
    }

    public String property(String key, String defaultValue) {
        return StringUtils.defaultString((Object)this.properties.get(key), (String)defaultValue);
    }
}

