/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.sonar.api.Plugin;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.UriReader;
import org.sonar.batch.bootstrap.BatchDatabase;
import org.sonar.batch.bootstrap.BatchDatabaseSessionFactory;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.BatchSettings;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrap.DatabaseCompatibility;
import org.sonar.batch.bootstrap.DryRunDatabase;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.FileCacheProvider;
import org.sonar.batch.bootstrap.JdbcDriverHolder;
import org.sonar.batch.bootstrap.PluginDownloader;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.ServerMetadata;
import org.sonar.batch.bootstrap.TaskContainer;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByPreviousVersion;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.core.config.Logback;
import org.sonar.core.i18n.I18nManager;
import org.sonar.core.i18n.RuleI18nManager;
import org.sonar.core.metric.CacheMetricFinder;
import org.sonar.core.persistence.DaoUtils;
import org.sonar.core.persistence.DatabaseVersion;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.persistence.SemaphoreUpdater;
import org.sonar.core.persistence.SemaphoresImpl;
import org.sonar.core.purge.PurgeProfiler;
import org.sonar.core.qualitymodel.DefaultModelFinder;
import org.sonar.core.rule.CacheRuleFinder;
import org.sonar.core.user.HibernateUserFinder;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.dao.ProfilesDao;
import org.sonar.jpa.dao.RulesDao;
import org.sonar.jpa.session.DefaultDatabaseConnector;
import org.sonar.jpa.session.JpaDatabaseSession;

public class BootstrapContainer
extends ComponentContainer {
    private BootstrapContainer() {
    }

    public static BootstrapContainer create(List objects) {
        BootstrapContainer container = new BootstrapContainer();
        container.add(new Object[]{objects});
        return container;
    }

    protected void doBeforeStart() {
        this.addBootstrapComponents();
        this.addDatabaseComponents();
        this.addCoreComponents();
    }

    private void addBootstrapComponents() {
        this.add(new Object[]{new PropertiesConfiguration(), BootstrapSettings.class, PluginDownloader.class, BatchPluginRepository.class, BatchSettings.class, ServerClient.class, ExtensionInstaller.class, Logback.class, ServerMetadata.class, org.sonar.batch.ServerMetadata.class, TempDirectories.class, HttpDownloader.class, UriReader.class, new FileCacheProvider()});
    }

    private void addDatabaseComponents() {
        this.add(new Object[]{DryRunDatabase.class, JdbcDriverHolder.class, BatchDatabase.class, MyBatis.class, DatabaseVersion.class, DatabaseCompatibility.class, DefaultDatabaseConnector.class, JpaDatabaseSession.class, BatchDatabaseSessionFactory.class, DaoUtils.getDaoClasses(), PurgeProfiler.class});
    }

    private void addCoreComponents() {
        this.add(new Object[]{EmailSettings.class, I18nManager.class, RuleI18nManager.class, MeasuresDao.class, RulesDao.class, ProfilesDao.class, CacheRuleFinder.class, CacheMetricFinder.class, HibernateUserFinder.class, SemaphoreUpdater.class, SemaphoresImpl.class, PastSnapshotFinderByDate.class, PastSnapshotFinderByDays.class, PastSnapshotFinderByPreviousAnalysis.class, PastSnapshotFinderByVersion.class, PastSnapshotFinderByPreviousVersion.class, PastMeasuresLoader.class, PastSnapshotFinder.class, DefaultModelFinder.class});
    }

    protected void doAfterStart() {
        this.installPlugins();
        this.executeTask();
    }

    private void installPlugins() {
        for (Map.Entry<PluginMetadata, Plugin> entry : ((BatchPluginRepository)this.getComponentByType(BatchPluginRepository.class)).getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            this.addExtension(metadata, plugin);
        }
    }

    void executeTask() {
        new TaskContainer(this).execute();
    }
}

