/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrap.ServerClient;

public class BatchSettings
extends Settings {
    private Configuration deprecatedConfiguration;
    private Map<String, Map<String, String>> moduleProperties = Maps.newHashMap();
    private final BootstrapSettings bootstrapSettings;
    private final ServerClient client;
    private Map<String, String> savedProperties;

    public BatchSettings(BootstrapSettings bootstrapSettings, PropertyDefinitions propertyDefinitions, ServerClient client, Configuration deprecatedConfiguration) {
        super(propertyDefinitions);
        this.bootstrapSettings = bootstrapSettings;
        this.client = client;
        this.deprecatedConfiguration = deprecatedConfiguration;
        this.init(null);
    }

    public void init(@Nullable ProjectReactor reactor) {
        this.savedProperties = this.getProperties();
        if (reactor != null) {
            LoggerFactory.getLogger(BatchSettings.class).info("Load project settings");
            String branch = this.bootstrapSettings.property("sonar.branch");
            String projectKey = reactor.getRoot().getKey();
            if (StringUtils.isNotBlank((String)branch)) {
                projectKey = String.format("%s:%s", projectKey, branch);
            }
            this.downloadSettings(this.client, projectKey);
        } else {
            LoggerFactory.getLogger(BatchSettings.class).info("Load batch settings");
            this.downloadSettings(this.client, null);
        }
        this.addProperties(this.bootstrapSettings.properties());
        if (reactor != null) {
            this.addProperties(reactor.getRoot().getProperties());
        }
        this.properties.putAll(System.getenv());
        this.addProperties(System.getProperties());
    }

    public void restore() {
        this.setProperties(this.savedProperties);
    }

    private void downloadSettings(ServerClient client, @Nullable String projectKey) {
        String url = StringUtils.isNotBlank((String)projectKey) ? "/batch_bootstrap/properties?project=" + projectKey : "/batch_bootstrap/properties";
        String jsonText = client.request(url);
        List json = (List)JSONValue.parse((String)jsonText);
        for (Map jsonProperty : json) {
            String key = (String)jsonProperty.get("k");
            String value = (String)jsonProperty.get("v");
            String moduleKey = (String)jsonProperty.get("p");
            if (moduleKey == null || projectKey == null || moduleKey.equals(projectKey)) {
                this.setProperty(key, value);
            }
            if (moduleKey == null) continue;
            HashMap map = this.moduleProperties.get(moduleKey);
            if (map == null) {
                map = Maps.newHashMap();
                this.moduleProperties.put(moduleKey, map);
            }
            map.put(key, value);
        }
    }

    public Map<String, String> getModuleProperties(String projectKey) {
        return this.moduleProperties.get(projectKey);
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedConfiguration.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedConfiguration.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedConfiguration.clear();
    }
}

