/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Project;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.scan.ScanContainer;
import org.sonar.batch.tasks.RequiresProject;

@RequiresProject
public class ScanTask
implements Task {
    public static final String COMMAND = "inspect";
    public static final TaskDefinition DEFINITION = TaskDefinition.create().setDescription("Scan project and upload report to server").setName("Project Scan").setCommand("inspect").setTask(ScanTask.class);
    private final ComponentContainer container;
    private final ProjectTree projectTree;

    public ScanTask(ProjectTree projectTree, ComponentContainer container) {
        this.container = container;
        this.projectTree = projectTree;
    }

    public void execute() {
        this.scanRecursively(this.projectTree.getRootProject());
    }

    private void scanRecursively(Project project) {
        for (Project subProject : project.getModules()) {
            this.scanRecursively(subProject);
        }
        this.scan(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void scan(Project project) {
        ScanContainer projectModule = new ScanContainer(project);
        try {
            ComponentContainer childContainer = this.container.createChild();
            projectModule.init(childContainer);
            projectModule.start();
        }
        finally {
            projectModule.stop();
            this.container.removeChild();
        }
    }
}

