/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.task.TaskExtension;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.tasks.RequiresProject;
import org.sonar.core.DryRunIncompatible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExtensionUtils {
    private ExtensionUtils() {
    }

    static boolean isInstantiationStrategy(Object extension, String strategy) {
        InstantiationStrategy annotation = (InstantiationStrategy)AnnotationUtils.getAnnotation((Object)extension, InstantiationStrategy.class);
        if (annotation != null) {
            return strategy.equals(annotation.value());
        }
        return "PER_PROJECT".equals(strategy);
    }

    static boolean isTaskExtension(Object extension) {
        return ExtensionUtils.isType(extension, TaskExtension.class);
    }

    static boolean isBatchExtension(Object extension) {
        return ExtensionUtils.isType(extension, BatchExtension.class);
    }

    static boolean supportsEnvironment(Object extension, EnvironmentInformation environment) {
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getAnnotation((Object)extension, SupportedEnvironment.class);
        if (env == null) {
            return true;
        }
        for (String supported : env.value()) {
            if (!StringUtils.equalsIgnoreCase((String)environment.getKey(), (String)supported)) continue;
            return true;
        }
        return false;
    }

    static boolean supportsDryRun(Object extension) {
        return AnnotationUtils.getAnnotation((Object)extension, DryRunIncompatible.class) == null;
    }

    static boolean requiresProject(Object extension) {
        return AnnotationUtils.getAnnotation((Object)extension, RequiresProject.class) != null;
    }

    static boolean isMavenExtensionOnly(Object extension) {
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getAnnotation((Object)extension, SupportedEnvironment.class);
        return env != null && env.value().length == 1 && StringUtils.equalsIgnoreCase((String)"maven", (String)env.value()[0]);
    }

    static boolean isType(Object extension, Class<?> extensionClass) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        return extensionClass.isAssignableFrom(clazz);
    }
}

