/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.batch.bootstrap.ServerMetadata;
import org.sonar.core.persistence.BadDatabaseVersion;
import org.sonar.core.persistence.DatabaseVersion;

public class DatabaseCompatibility
implements BatchComponent {
    private DatabaseVersion version;
    private Settings settings;
    private ServerMetadata server;

    public DatabaseCompatibility(DatabaseVersion version, ServerMetadata server, Settings settings) {
        this.version = version;
        this.server = server;
        this.settings = settings;
    }

    public void start() {
        if (!this.settings.getBoolean("sonar.dryRun")) {
            this.checkCorrectServerId();
            this.checkDatabaseStatus();
        }
    }

    private void checkCorrectServerId() {
        if (!this.settings.getString("sonar.core.id").equals(this.server.getServerId())) {
            StringBuilder message = new StringBuilder("The current batch process and the configured remote server do not share the same DB configuration.\n");
            message.append("\t- Batch side: ");
            message.append(this.settings.getString("sonar.jdbc.url"));
            message.append(" (");
            String userName = this.settings.getString("sonar.jdbc.username");
            message.append(userName == null ? "sonar" : userName);
            message.append(" / *****)\n\t- Server side: check the configuration at ");
            message.append(this.server.getURL());
            message.append("/system\n");
            throw new BadDatabaseVersion(message.toString());
        }
    }

    private void checkDatabaseStatus() {
        DatabaseVersion.Status status = this.version.getStatus();
        if (status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
            throw new BadDatabaseVersion("Database relates to a more recent version of Sonar. Please check your settings (JDBC settings, version of Maven plugin)");
        }
        if (status == DatabaseVersion.Status.REQUIRES_UPGRADE) {
            throw new BadDatabaseVersion("Database must be upgraded. Please browse " + this.server.getURL() + "/setup");
        }
        if (status != DatabaseVersion.Status.UP_TO_DATE) {
            throw new BadDatabaseVersion("Unknown database status: " + status);
        }
    }
}

