/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.utils.WildcardPattern;

abstract class PathPattern {
    final WildcardPattern pattern;

    PathPattern(String pattern) {
        this.pattern = WildcardPattern.create((String)pattern);
    }

    abstract boolean match(FileSystemFilter.Context var1);

    abstract boolean match(Resource var1);

    abstract boolean supportResource();

    static PathPattern create(String s) {
        String trimmed = StringUtils.trim((String)s);
        if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"file:")) {
            return new AbsolutePathPattern(StringUtils.substring((String)trimmed, (int)"file:".length()));
        }
        return new RelativePathPattern(trimmed);
    }

    static PathPattern[] create(String[] s) {
        PathPattern[] result = new PathPattern[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = PathPattern.create(s[i]);
        }
        return result;
    }

    private static class RelativePathPattern
    extends PathPattern {
        private RelativePathPattern(String pattern) {
            super(pattern);
        }

        boolean match(FileSystemFilter.Context context) {
            return this.pattern.match(context.relativePath());
        }

        boolean match(Resource resource) {
            return resource.matchFilePattern(this.pattern.toString());
        }

        boolean supportResource() {
            return true;
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    private static class AbsolutePathPattern
    extends PathPattern {
        private AbsolutePathPattern(String pattern) {
            super(pattern);
        }

        boolean match(FileSystemFilter.Context context) {
            return this.pattern.match(context.canonicalPath());
        }

        boolean match(Resource resource) {
            return false;
        }

        boolean supportResource() {
            return false;
        }

        public String toString() {
            return "file:" + this.pattern.toString();
        }
    }
}

