/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.core.i18n.RuleI18nManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryRunExporter
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DryRunExporter.class);
    private final Settings settings;
    private final DefaultIndex sonarIndex;
    private final ProjectFileSystem projectFileSystem;
    private final Server server;
    private final RuleI18nManager ruleI18nManager;

    public DryRunExporter(Settings settings, DefaultIndex sonarIndex, ProjectFileSystem projectFileSystem, Server server, RuleI18nManager ruleI18nManager) {
        this.settings = settings;
        this.sonarIndex = sonarIndex;
        this.projectFileSystem = projectFileSystem;
        this.server = server;
        this.ruleI18nManager = ruleI18nManager;
    }

    public void execute(SensorContext context) {
        if (this.settings.getBoolean("sonar.dryRun")) {
            this.exportResults(this.sonarIndex.getResources());
        }
    }

    private void exportResults(Collection<Resource> resources) {
        File exportFile = new File(this.projectFileSystem.getSonarWorkingDirectory(), this.settings.getString("sonar.dryRun.export.path"));
        LOG.info("Exporting DryRun results to " + exportFile.getAbsolutePath());
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(exportFile));
            this.writeJson(resources, output);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Unable to write DryRun results in file " + exportFile.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }

    @VisibleForTesting
    void writeJson(Collection<Resource> resources, Writer output) {
        JsonWriter json = null;
        try {
            json = new JsonWriter(output);
            json.setSerializeNulls(false);
            json.beginObject().name("version").value(this.server.getVersion()).name("violations_per_resource").beginObject();
            for (Resource resource : resources) {
                List<Violation> violations = this.getViolations(resource);
                if (violations.isEmpty()) continue;
                json.name(resource.getKey()).beginArray();
                for (Violation violation : violations) {
                    json.beginObject().name("line").value((Number)violation.getLineId()).name("message").value(violation.getMessage()).name("severity").value(violation.getSeverity().name()).name("rule_key").value(violation.getRule().getKey()).name("rule_repository").value(violation.getRule().getRepositoryKey()).name("rule_name").value(this.name(violation.getRule())).endObject();
                }
                json.endArray();
            }
            json.endObject().endObject().flush();
        }
        catch (IOException e) {
            try {
                throw new SonarException("Unable to export results", (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(json);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)json);
    }

    private String name(Rule rule) {
        return this.ruleI18nManager.getName(rule, Locale.getDefault());
    }

    @VisibleForTesting
    List<Violation> getViolations(Resource resource) {
        return this.sonarIndex.getViolations(resource);
    }
}

