/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.platform.ComponentContainer;

public abstract class Module {
    ComponentContainer container;

    public final void init() {
        this.init(new ComponentContainer());
    }

    private void init(ComponentContainer container) {
        this.container = container;
        this.configure();
    }

    public final Module installChild(Module child) {
        ComponentContainer childContainer = this.container.createChild();
        child.init(childContainer);
        return child;
    }

    public final void uninstallChild() {
        this.container.removeChild();
    }

    public final Module start() {
        this.container.startComponents();
        this.doStart();
        return this;
    }

    protected void doStart() {
    }

    public final Module stop() {
        try {
            this.doStop();
            this.container.stopComponents();
            this.container.removeChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    protected void doStop() {
    }

    protected abstract void configure();
}

