/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.BatchComponent;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.resources.Project;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public class ExtensionInstaller
implements BatchComponent {
    private BatchPluginRepository pluginRepository;
    private EnvironmentInformation environment;
    private Settings settings;

    public ExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation environment, Settings settings) {
        this.pluginRepository = pluginRepository;
        this.environment = environment;
        this.settings = settings;
    }

    public void install(ComponentContainer container, String instantiationStrategy) {
        boolean dryRun = this.settings.getBoolean("sonar.dryRun");
        for (Map.Entry<PluginMetadata, Plugin> entry : this.pluginRepository.getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            container.addExtension(metadata, (Object)plugin);
            for (Object extension : plugin.getExtensions()) {
                this.installExtension(container, metadata, extension, dryRun, instantiationStrategy);
            }
        }
        List providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            this.executeProvider(container, instantiationStrategy, dryRun, provider);
        }
    }

    private void executeProvider(ComponentContainer container, String instantiationStrategy, boolean dryRun, ExtensionProvider provider) {
        Object obj = provider.provide();
        if (obj instanceof Iterable) {
            for (Object extension : (Iterable)obj) {
                this.installExtension(container, null, extension, dryRun, instantiationStrategy);
            }
        } else {
            this.installExtension(container, null, obj, dryRun, instantiationStrategy);
        }
    }

    boolean installExtension(ComponentContainer container, @Nullable PluginMetadata plugin, Object extension, boolean dryRun, String instantiationStrategy) {
        boolean installed;
        if (ExtensionUtils.isBatchExtension(extension) && ExtensionUtils.supportsEnvironment(extension, this.environment) && (!dryRun || ExtensionUtils.supportsDryRun(extension)) && ExtensionUtils.isInstantiationStrategy(extension, instantiationStrategy) && !ExtensionInstaller.isMavenExtensionOnEmulatedMavenProject(extension, instantiationStrategy, container)) {
            container.addExtension(plugin, extension);
            installed = true;
        } else {
            container.declareExtension(plugin, extension);
            installed = false;
        }
        return installed;
    }

    static boolean isMavenExtensionOnEmulatedMavenProject(Object extension, String instantiationStrategy, ComponentContainer container) {
        if ("PER_PROJECT".equals(instantiationStrategy) && ExtensionUtils.isMavenExtensionOnly(extension)) {
            Project project = (Project)container.getComponentByType(Project.class);
            return project != null && project.getPom() == null;
        }
        return false;
    }
}

