/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.resources.Project;
import org.sonar.batch.ProjectConfigurator;
import org.sonar.batch.bootstrap.ProjectReactorReady;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTree {
    private final ProjectConfigurator configurator;
    private ProjectReactor projectReactor;
    private List<Project> projects;
    private Map<ProjectDefinition, Project> projectsByDef;

    public ProjectTree(ProjectReactor projectReactor, ProjectConfigurator projectConfigurator, ProjectReactorReady reactorReady) {
        this.projectReactor = projectReactor;
        this.configurator = projectConfigurator;
    }

    public void start() {
        this.doStart(this.projectReactor.getProjects());
    }

    void doStart(List<ProjectDefinition> definitions) {
        this.projects = Lists.newArrayList();
        this.projectsByDef = Maps.newHashMap();
        for (ProjectDefinition projectDefinition : definitions) {
            Project project = this.configurator.create(projectDefinition);
            this.projectsByDef.put(projectDefinition, project);
            this.projects.add(project);
        }
        for (Map.Entry entry : this.projectsByDef.entrySet()) {
            ProjectDefinition def = (ProjectDefinition)entry.getKey();
            Project project = (Project)entry.getValue();
            for (ProjectDefinition module : def.getSubProjects()) {
                this.projectsByDef.get(module).setParent(project);
            }
        }
        for (Project project : this.projects) {
            this.configurator.configure(project);
        }
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Project getRootProject() {
        for (Project project : this.projects) {
            if (project.getParent() != null) continue;
            return project;
        }
        throw new IllegalStateException("Can not find the root project from the list of Maven modules");
    }

    public ProjectDefinition getProjectDefinition(Project project) {
        for (Map.Entry<ProjectDefinition, Project> entry : this.projectsByDef.entrySet()) {
            if (!ObjectUtils.equals((Object)entry.getValue(), (Object)project)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Can not find ProjectDefinition for " + project);
    }
}

