/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.ArrayListMultimap;
import java.util.Map;
import org.sonar.api.BatchComponent;
import org.sonar.api.Extension;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.DryRun;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchExtensionInstaller
implements BatchComponent {
    private BatchPluginRepository pluginRepository;
    private EnvironmentInformation environment;
    private DryRun dryRun;

    public BatchExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation environment, DryRun dryRun) {
        this.pluginRepository = pluginRepository;
        this.environment = environment;
        this.dryRun = dryRun;
    }

    public void install(Module module) {
        ArrayListMultimap installedExtensionsByPlugin = ArrayListMultimap.create();
        for (Map.Entry<PluginMetadata, Plugin> entry : this.pluginRepository.getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            module.addExtension(metadata, plugin);
            for (Object extension : plugin.getExtensions()) {
                if (this.installExtension(module, metadata, extension)) {
                    installedExtensionsByPlugin.put((Object)metadata, extension);
                    continue;
                }
                module.declareExtension(metadata, extension);
            }
        }
        for (Map.Entry<Object, Object> entry : installedExtensionsByPlugin.entries()) {
            PluginMetadata plugin = (PluginMetadata)entry.getKey();
            Object extension = entry.getValue();
            if (!BatchExtensionInstaller.isExtensionProvider(extension)) continue;
            ExtensionProvider provider = (ExtensionProvider)module.getComponentByKey(extension);
            this.installProvider(module, plugin, provider);
        }
        this.installMetrics(module);
    }

    static boolean isExtensionProvider(Object extension) {
        return BatchExtensionInstaller.isType(extension, ExtensionProvider.class) || extension instanceof ExtensionProvider;
    }

    static boolean isType(Object extension, Class<? extends Extension> extensionClass) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        return extensionClass.isAssignableFrom(clazz);
    }

    private void installMetrics(Module module) {
        for (Metrics metrics : module.getComponents(Metrics.class)) {
            for (Metric metric : metrics.getMetrics()) {
                module.addCoreSingleton(metric);
            }
        }
    }

    private void installProvider(Module module, PluginMetadata plugin, ExtensionProvider provider) {
        Object obj = provider.provide();
        if (obj != null) {
            if (obj instanceof Iterable) {
                for (Object ext : (Iterable)obj) {
                    this.installExtension(module, plugin, ext);
                }
            } else {
                this.installExtension(module, plugin, obj);
            }
        }
    }

    boolean installExtension(Module module, PluginMetadata plugin, Object extension) {
        if (ExtensionUtils.isBatchExtension(extension) && ExtensionUtils.isSupportedEnvironment(extension, this.environment) && ExtensionUtils.checkDryRun(extension, this.dryRun.isEnabled()) && ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH")) {
            if (ExtensionUtils.isType(extension, CoverageExtension.class)) {
                throw new IllegalArgumentException("Instantiation strategy PER_BATCH is not supported on CoverageExtension components: " + extension);
            }
            module.addExtension(plugin, extension);
            return true;
        }
        return false;
    }
}

