/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Resource;
import org.sonar.batch.components.PastSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastMeasuresLoader
implements BatchExtension {
    private Map<Integer, Metric> metricByIds;
    private DatabaseSession session;

    public PastMeasuresLoader(DatabaseSession session, MetricFinder metricFinder) {
        this(session, metricFinder.findAll());
    }

    PastMeasuresLoader(DatabaseSession session, Collection<Metric> metrics) {
        this.session = session;
        this.metricByIds = Maps.newHashMap();
        for (Metric metric : metrics) {
            if (!metric.isNumericType()) continue;
            this.metricByIds.put(metric.getId(), metric);
        }
    }

    public Collection<Metric> getMetrics() {
        return this.metricByIds.values();
    }

    public List<Object[]> getPastMeasures(Resource resource, PastSnapshot projectPastSnapshot) {
        if (projectPastSnapshot != null && projectPastSnapshot.getProjectSnapshot() != null) {
            return this.getPastMeasures(resource.getEffectiveKey(), projectPastSnapshot.getProjectSnapshot());
        }
        return Collections.emptyList();
    }

    public List<Object[]> getPastMeasures(String resourceKey, Snapshot projectPastSnapshot) {
        String sql = "select m.metric_id, m.characteristic_id, m.rule_id, m.rule_priority, m.value from project_measures m, snapshots s where m.snapshot_id=s.id and m.metric_id in (:metricIds)  and (s.root_snapshot_id=:rootSnapshotId or s.id=:rootSnapshotId) and s.status=:status and s.project_id=(select p.id from projects p where p.kee=:resourceKey and p.qualifier<>:lib)";
        return this.session.createNativeQuery(sql).setParameter("metricIds", this.metricByIds.keySet()).setParameter("rootSnapshotId", ObjectUtils.defaultIfNull((Object)projectPastSnapshot.getRootId(), (Object)projectPastSnapshot.getId())).setParameter("resourceKey", (Object)resourceKey).setParameter("lib", (Object)"LIB").setParameter("status", (Object)"P").getResultList();
    }

    public static int getMetricId(Object[] row) {
        return ((Number)row[0]).intValue();
    }

    public static Integer getCharacteristicId(Object[] row) {
        Number number = (Number)row[1];
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public static Integer getRuleId(Object[] row) {
        Number number = (Number)row[2];
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public static Integer getSeverityId(Object[] row) {
        Number number = (Number)row[3];
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public static boolean hasValue(Object[] row) {
        return row[4] != null;
    }

    public static double getValue(Object[] row) {
        return ((Number)row[4]).doubleValue();
    }
}

