/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.Arrays;
import org.picocontainer.ComponentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.DefaultRulesManager;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.DefaultProfileLoader;
import org.sonar.batch.DefaultProjectClasspath;
import org.sonar.batch.DefaultProjectFileSystem2;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProfileLoader;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.ProjectExtensionInstaller;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.phases.PhasesTimeProfiler;
import org.sonar.core.components.DefaultModelFinder;
import org.sonar.jpa.dao.AsyncMeasuresDao;
import org.sonar.jpa.dao.AsyncMeasuresService;
import org.sonar.jpa.dao.DaoFacade;
import org.sonar.jpa.dao.ProfilesDao;
import org.sonar.jpa.dao.RulesDao;

public class ProjectModule
extends Module {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectModule.class);
    private Project project;
    private boolean dryRun;

    public ProjectModule(Project project, boolean dryRun) {
        this.project = project;
        this.dryRun = dryRun;
    }

    protected void configure() {
        this.logSettings();
        this.addCoreComponents();
        this.addProjectComponents();
        this.addProjectPluginExtensions();
    }

    private void addProjectComponents() {
        ProjectDefinition projectDefinition = this.getComponent(ProjectTree.class).getProjectDefinition(this.project);
        this.addComponent(projectDefinition);
        for (Object component : projectDefinition.getContainerExtensions()) {
            this.addComponent(component);
        }
        this.addComponent(this.project);
        this.addComponent(this.project.getConfiguration());
        this.addComponent(DefaultProjectClasspath.class);
        this.addComponent(DefaultProjectFileSystem2.class);
        this.addComponent(DaoFacade.class);
        this.addComponent(RulesDao.class);
        if (!this.dryRun) {
            this.addComponent(this.getComponent(DefaultResourcePersister.class).getSnapshot((Resource)this.project));
        }
        this.addComponent(TimeMachineConfiguration.class);
        this.addComponent(MeasuresDao.class);
        this.addComponent(ProfilesDao.class);
        this.addComponent(AsyncMeasuresDao.class);
        this.addComponent(AsyncMeasuresService.class);
        this.addComponent(DefaultRulesManager.class);
        this.addComponent(DefaultSensorContext.class);
        this.addComponent(Languages.class);
        this.addComponent(BatchExtensionDictionnary.class);
        this.addComponent(DefaultTimeMachine.class);
        this.addComponent(ViolationFilters.class);
        this.addComponent(ResourceFilters.class);
        this.addComponent(DefaultModelFinder.class);
        this.addComponent(ProfileLoader.class, DefaultProfileLoader.class);
        this.addAdapter((ComponentAdapter<?>)new ProfileProvider());
    }

    private void addCoreComponents() {
        this.addComponent(EventBus.class);
        this.addComponent(Phases.class);
        this.addComponent(PhasesTimeProfiler.class);
        for (Class clazz : Phases.getPhaseClasses(this.dryRun)) {
            this.addComponent(clazz);
        }
    }

    private void addProjectPluginExtensions() {
        ProjectExtensionInstaller installer = this.getComponent(ProjectExtensionInstaller.class);
        installer.install(this, this.project);
    }

    private void logSettings() {
        LOG.info("-------------  Analyzing {}", (Object)this.project.getName());
        Object[] exclusionPatterns = this.project.getExclusionPatterns();
        if (exclusionPatterns != null && exclusionPatterns.length > 0) {
            LOG.info("Excluded sources : {}", (Object)Arrays.toString(exclusionPatterns));
        }
    }

    protected void doStart() {
        Language language = this.getComponent(Languages.class).get(this.project.getLanguageKey());
        if (language == null) {
            throw new SonarException("Language with key '" + this.project.getLanguageKey() + "' not found");
        }
        this.project.setLanguage(language);
        DefaultIndex index = this.getComponent(DefaultIndex.class);
        index.setCurrentProject(this.project, this.getComponent(ResourceFilters.class), this.getComponent(ViolationFilters.class), this.getComponent(RulesProfile.class));
        this.project.setFileSystem(this.getComponent(ProjectFileSystem.class));
        this.getComponent(Phases.class).execute(this.project);
    }
}

